/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal.predicate.doubles;

import com.speedment.common.tuple.Tuple2;
import com.speedment.runtime.field.internal.predicate.AbstractFieldPredicate;
import com.speedment.runtime.field.internal.predicate.doubles.DoubleBetweenPredicate;
import com.speedment.runtime.field.predicate.Inclusion;
import com.speedment.runtime.field.predicate.PredicateType;
import com.speedment.runtime.field.predicate.trait.HasInclusion;
import com.speedment.runtime.field.trait.HasDoubleValue;
import java.util.Objects;

public final class DoubleNotBetweenPredicate<ENTITY, D>
extends AbstractFieldPredicate<ENTITY, HasDoubleValue<ENTITY, D>>
implements HasInclusion,
Tuple2<Double, Double> {
    private final double start;
    private final double end;
    private final Inclusion inclusion;

    public DoubleNotBetweenPredicate(HasDoubleValue<ENTITY, D> field, double start, double end, Inclusion inclusion) {
        super(PredicateType.NOT_BETWEEN, field, entity -> {
            double fieldValue = field.getAsDouble(entity);
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    return start >= fieldValue || end <= fieldValue;
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    return start >= fieldValue || end < fieldValue;
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    return start > fieldValue || end <= fieldValue;
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    return start > fieldValue || end < fieldValue;
                }
            }
            throw new IllegalStateException("Inclusion unknown: " + (Object)((Object)inclusion));
        });
        this.start = start;
        this.end = end;
        this.inclusion = Objects.requireNonNull(inclusion);
    }

    public Double get0() {
        return this.start;
    }

    public Double get1() {
        return this.end;
    }

    @Override
    public Inclusion getInclusion() {
        return this.inclusion;
    }

    @Override
    public DoubleBetweenPredicate<ENTITY, D> negate() {
        return new DoubleBetweenPredicate((HasDoubleValue)this.getField(), this.start, this.end, this.inclusion);
    }
}

