/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal.predicate.ints;

import com.speedment.common.tuple.Tuple2;
import com.speedment.runtime.field.internal.predicate.AbstractFieldPredicate;
import com.speedment.runtime.field.internal.predicate.ints.IntNotBetweenPredicate;
import com.speedment.runtime.field.predicate.Inclusion;
import com.speedment.runtime.field.predicate.PredicateType;
import com.speedment.runtime.field.predicate.trait.HasInclusion;
import com.speedment.runtime.field.trait.HasIntValue;
import java.util.Objects;

public final class IntBetweenPredicate<ENTITY, D>
extends AbstractFieldPredicate<ENTITY, HasIntValue<ENTITY, D>>
implements HasInclusion,
Tuple2<Integer, Integer> {
    private final int start;
    private final int end;
    private final Inclusion inclusion;

    public IntBetweenPredicate(HasIntValue<ENTITY, D> field, int start, int end, Inclusion inclusion) {
        super(PredicateType.BETWEEN, field, entity -> {
            int fieldValue = field.getAsInt(entity);
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    return start < fieldValue && end > fieldValue;
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    return start < fieldValue && end >= fieldValue;
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    return start <= fieldValue && end > fieldValue;
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    return start <= fieldValue && end >= fieldValue;
                }
            }
            throw new IllegalStateException("Inclusion unknown: " + (Object)((Object)inclusion));
        });
        this.start = start;
        this.end = end;
        this.inclusion = Objects.requireNonNull(inclusion);
    }

    public Integer get0() {
        return this.start;
    }

    public Integer get1() {
        return this.end;
    }

    @Override
    public Inclusion getInclusion() {
        return this.inclusion;
    }

    @Override
    public IntNotBetweenPredicate<ENTITY, D> negate() {
        return new IntNotBetweenPredicate((HasIntValue)this.getField(), this.start, this.end, this.inclusion);
    }
}

