/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.internal.predicate.reference;

import com.speedment.common.tuple.Tuple2;
import com.speedment.runtime.field.internal.predicate.AbstractFieldPredicate;
import com.speedment.runtime.field.internal.predicate.reference.ReferenceNotBetweenPredicate;
import com.speedment.runtime.field.predicate.Inclusion;
import com.speedment.runtime.field.predicate.PredicateType;
import com.speedment.runtime.field.predicate.trait.HasInclusion;
import com.speedment.runtime.field.trait.HasReferenceValue;
import java.util.Objects;
import java.util.function.Predicate;

public final class ReferenceBetweenPredicate<ENTITY, D, V extends Comparable<? super V>>
extends AbstractFieldPredicate<ENTITY, HasReferenceValue<ENTITY, D, V>>
implements HasInclusion,
Tuple2<V, V> {
    private final V start;
    private final V end;
    private final Inclusion inclusion;

    public ReferenceBetweenPredicate(HasReferenceValue<ENTITY, D, V> referenceField, V start, V end, Inclusion inclusion) {
        super(PredicateType.BETWEEN, referenceField, ReferenceBetweenPredicate.entityPredicate(referenceField, start, end, inclusion));
        this.start = start;
        this.end = end;
        this.inclusion = Objects.requireNonNull(inclusion);
    }

    private static <ENTITY, D, V extends Comparable<? super V>> Predicate<ENTITY> entityPredicate(HasReferenceValue<ENTITY, D, V> referenceField, V start, V end, Inclusion inclusion) {
        return entity -> {
            Comparable fieldValue = (Comparable)referenceField.get(entity);
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    return ReferenceBetweenPredicate.startExclusiveEndExclusive(start, end, fieldValue);
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    return ReferenceBetweenPredicate.startExclusiveEndIncluseve(start, end, fieldValue);
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    return ReferenceBetweenPredicate.startInclusiveEndExclusive(start, end, fieldValue);
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    return ReferenceBetweenPredicate.startInclusiveEndInclusive(start, end, fieldValue);
                }
            }
            throw new IllegalStateException("Inclusion unknown: " + (Object)((Object)inclusion));
        };
    }

    private static <V extends Comparable<? super V>> boolean startInclusiveEndInclusive(V start, V end, V fieldValue) {
        if (fieldValue == null) {
            return start == null || end == null;
        }
        if (start == null || end == null) {
            return false;
        }
        return start.compareTo(fieldValue) <= 0 && end.compareTo(fieldValue) >= 0;
    }

    private static <V extends Comparable<? super V>> boolean startInclusiveEndExclusive(V start, V end, V fieldValue) {
        if (fieldValue == null) {
            return start == null && end != null;
        }
        if (start == null || end == null) {
            return false;
        }
        return start.compareTo(fieldValue) <= 0 && end.compareTo(fieldValue) > 0;
    }

    private static <V extends Comparable<? super V>> boolean startExclusiveEndIncluseve(V start, V end, V fieldValue) {
        if (fieldValue == null) {
            return start != null && end == null;
        }
        if (start == null || end == null) {
            return false;
        }
        return start.compareTo(fieldValue) < 0 && end.compareTo(fieldValue) >= 0;
    }

    private static <V extends Comparable<? super V>> boolean startExclusiveEndExclusive(V start, V end, V fieldValue) {
        if (fieldValue == null) {
            return false;
        }
        if (start == null || end == null) {
            return false;
        }
        return start.compareTo(fieldValue) < 0 && end.compareTo(fieldValue) > 0;
    }

    public V get0() {
        return this.start;
    }

    public V get1() {
        return this.end;
    }

    @Override
    public Inclusion getInclusion() {
        return this.inclusion;
    }

    @Override
    public ReferenceNotBetweenPredicate<ENTITY, D, V> negate() {
        return new ReferenceNotBetweenPredicate((HasReferenceValue)this.getField(), this.start, this.end, this.inclusion);
    }
}

