/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.field.trait;

import com.speedment.runtime.compute.trait.HasCompare;
import com.speedment.runtime.field.Field;
import com.speedment.runtime.field.comparator.FieldComparator;
import com.speedment.runtime.field.predicate.Inclusion;
import com.speedment.runtime.field.predicate.SpeedmentPredicate;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface HasComparableOperators<ENTITY, V extends Comparable<? super V>>
extends Field<ENTITY>,
HasCompare<ENTITY> {
    public FieldComparator<ENTITY> comparator();

    public FieldComparator<ENTITY> comparatorNullFieldsFirst();

    public SpeedmentPredicate<ENTITY> equal(V var1);

    public SpeedmentPredicate<ENTITY> notEqual(V var1);

    public SpeedmentPredicate<ENTITY> lessThan(V var1);

    public SpeedmentPredicate<ENTITY> lessOrEqual(V var1);

    public SpeedmentPredicate<ENTITY> greaterThan(V var1);

    public SpeedmentPredicate<ENTITY> greaterOrEqual(V var1);

    default public SpeedmentPredicate<ENTITY> between(V start, V end) {
        return this.between(start, end, Inclusion.START_INCLUSIVE_END_EXCLUSIVE);
    }

    public SpeedmentPredicate<ENTITY> between(V var1, V var2, Inclusion var3);

    default public SpeedmentPredicate<ENTITY> notBetween(V start, V end) {
        return this.notBetween(start, end, Inclusion.START_INCLUSIVE_END_EXCLUSIVE);
    }

    public SpeedmentPredicate<ENTITY> notBetween(V var1, V var2, Inclusion var3);

    default public SpeedmentPredicate<ENTITY> in(V ... values) {
        return this.in(Stream.of(values).collect(Collectors.toSet()));
    }

    public SpeedmentPredicate<ENTITY> in(Collection<V> var1);

    default public SpeedmentPredicate<ENTITY> notIn(V ... values) {
        return this.notIn(Stream.of(values).collect(Collectors.toSet()));
    }

    public SpeedmentPredicate<ENTITY> notIn(Collection<V> var1);

    default public Comparator<ENTITY> reversed() {
        return this.comparator().reversed();
    }

    default public Comparator<ENTITY> thenComparing(Comparator<? super ENTITY> other) {
        return this.comparator().thenComparing(other);
    }

    default public <U> Comparator<ENTITY> thenComparing(Function<? super ENTITY, ? extends U> keyExtractor, Comparator<? super U> keyComparator) {
        return this.comparator().thenComparing(keyExtractor, keyComparator);
    }

    default public <U extends Comparable<? super U>> Comparator<ENTITY> thenComparing(Function<? super ENTITY, ? extends U> keyExtractor) {
        return this.comparator().thenComparing(keyExtractor);
    }

    default public Comparator<ENTITY> thenComparingInt(ToIntFunction<? super ENTITY> keyExtractor) {
        return this.comparator().thenComparingInt(keyExtractor);
    }

    default public Comparator<ENTITY> thenComparingLong(ToLongFunction<? super ENTITY> keyExtractor) {
        return this.comparator().thenComparingLong(keyExtractor);
    }

    default public Comparator<ENTITY> thenComparingDouble(ToDoubleFunction<? super ENTITY> keyExtractor) {
        return this.comparator().thenComparingDouble(keyExtractor);
    }
}

