/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.join.internal.component.join;

import com.speedment.common.logger.Level;
import com.speedment.common.logger.Logger;
import com.speedment.common.logger.LoggerManager;
import com.speedment.runtime.config.identifier.TableIdentifier;
import com.speedment.runtime.config.identifier.trait.HasColumnId;
import com.speedment.runtime.core.ApplicationBuilder;
import com.speedment.runtime.field.predicate.CombinedPredicate;
import com.speedment.runtime.field.predicate.FieldPredicate;
import com.speedment.runtime.field.trait.HasComparableOperators;
import com.speedment.runtime.field.trait.HasIdentifier;
import com.speedment.runtime.join.JoinStreamSupplierComponent;
import com.speedment.runtime.join.internal.component.join.StageBean;
import com.speedment.runtime.join.stage.JoinType;
import com.speedment.runtime.join.stage.Stage;
import com.speedment.runtime.join.trait.HasWhere;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

abstract class AbstractJoinBuilder<T, SELF>
implements HasWhere<T, SELF> {
    private static final Logger LOGGER_JOIN = LoggerManager.getLogger((String)ApplicationBuilder.LogType.JOIN.getLoggerName());
    private final JoinStreamSupplierComponent streamSupplier;
    private final List<StageBean<?>> stageBeans;
    private final StageBean<T> stageBean;

    AbstractJoinBuilder(JoinStreamSupplierComponent streamSupplier, TableIdentifier<T> initialTable) {
        this.streamSupplier = Objects.requireNonNull(streamSupplier);
        this.stageBeans = new ArrayList();
        this.stageBean = this.addStageBeanOf(Objects.requireNonNull(initialTable));
    }

    AbstractJoinBuilder(AbstractJoinBuilder<?, ?> previous, StageBean<T> stageBean) {
        Objects.requireNonNull(previous);
        this.streamSupplier = previous.streamSuppler();
        this.stageBeans = super.stageBeans();
        this.stageBean = Objects.requireNonNull(stageBean);
    }

    @Override
    public SELF where(Predicate<? super T> predicate) {
        this.addPredicate(predicate);
        return (SELF)this;
    }

    private <U> StageBean<U> addStageBeanOf(TableIdentifier<U> table) {
        return this.addStageBeanHelper(new StageBean<U>(table));
    }

    <U> StageBean<U> addStageBeanOf(TableIdentifier<U> table, JoinType joinType) {
        return this.addStageBeanHelper(new StageBean<U>(table, joinType));
    }

    <U> StageBean<U> addStageBeanOf(JoinType joinType, HasComparableOperators<U, ?> field) {
        return this.addStageBeanHelper(new StageBean<U>(joinType, field));
    }

    private <U> StageBean<U> addStageBeanHelper(StageBean<U> stageBean) {
        Objects.requireNonNull(stageBean);
        this.stageBeans.add(stageBean);
        return stageBean;
    }

    private List<StageBean<?>> stageBeans() {
        return this.stageBeans;
    }

    StageBean<T> stageBean() {
        return this.stageBean;
    }

    private void addPredicate(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (!(predicate instanceof FieldPredicate) && !(predicate instanceof CombinedPredicate)) {
            throw new IllegalArgumentException("The predicate " + predicate + " for join stage " + this.stageBeans.size() + " does not implement " + FieldPredicate.class.getName() + " or " + CombinedPredicate.class.getName() + ". Only Speedment predicates can be used for join operations (and thus no anonymous lambdas).");
        }
        this.stageBean.getPredicates().add(predicate);
    }

    JoinStreamSupplierComponent streamSuppler() {
        return this.streamSupplier;
    }

    List<Stage<?>> stages() {
        this.resolveStages();
        return this.stageBeans.stream().map(StageBean::asStage).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    private void resolveStages() {
        for (int i = 0; i < this.stageBeans.size(); ++i) {
            StageBean<?> currentStageBean = this.stageBeans.get(i);
            HasComparableOperators<?, ?> foreignField = currentStageBean.getForeignField();
            if (foreignField == null) {
                currentStageBean.setReferencedStage(-1);
                continue;
            }
            currentStageBean.setReferencedStage(AbstractJoinBuilder.stageIndexOf(this.stageBeans, foreignField, i));
        }
        if (LOGGER_JOIN.getLevel().isEqualOrHigherThan(Level.DEBUG)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Resolving join with ").append(this.stageBeans.size()).append(" stages:");
            sb.append(String.format("%n%2s %-32s %-12s %2s %-32s %-16s %-12s %-16s", "#", "Table Identifier", "Join Type", "R#", "Referenced Table Identifier", "Field", "Operation", "Referenced Field"));
            for (int i = 0; i < this.stageBeans.size(); ++i) {
                StageBean<?> stageBean = this.stageBeans.get(i);
                Optional<StageBean> referencedStageBean = Optional.of(stageBean.getReferencedStage()).filter(rs -> rs != -1).map(this.stageBeans::get);
                sb.append(String.format("%n%2d %-32s %-12s %2d %-32s %-16s %-12s %-16s", new Object[]{i, stageBean.getIdentifier(), stageBean.getJoinType(), stageBean.getReferencedStage(), referencedStageBean.map(StageBean::getIdentifier).orElse(null), Optional.ofNullable(stageBean.getField()).map(HasIdentifier::identifier).map(HasColumnId::getColumnId).orElse("null"), stageBean.getJoinOperator(), Optional.ofNullable(stageBean.getForeignField()).map(HasIdentifier::identifier).map(HasColumnId::getColumnId).orElse("null")}));
            }
            LOGGER_JOIN.debug(sb.toString());
        }
    }

    private static int stageIndexOf(List<StageBean<?>> stages, HasComparableOperators<?, ?> foreignField, int index) {
        LinkedHashSet<Integer> matches = new LinkedHashSet<Integer>();
        String foreignTableIdentifierString = AbstractJoinBuilder.tableIdentifierString(foreignField);
        for (int i = 0; i < stages.size(); ++i) {
            StageBean<?> stage = stages.get(i);
            String fieldTableIdentifierString = AbstractJoinBuilder.tableIdentifierString(stage);
            if (!fieldTableIdentifierString.equals(foreignTableIdentifierString)) continue;
            matches.add(i);
        }
        if (matches.size() > 1) {
            throw new IllegalStateException("The identifier " + foreignTableIdentifierString + " for stage index " + index + " is ambiguous. There are matching table identifiers for stage indexes " + matches + ". These table identifiers are available from previous join stages: " + stages.stream().map(AbstractJoinBuilder::tableIdentifierString).collect(Collectors.joining(", ")));
        }
        if (matches.size() == 1) {
            return (Integer)matches.iterator().next();
        }
        throw new IllegalStateException("There is no table for table identifier \"" + AbstractJoinBuilder.tableIdentifierString(foreignField) + "\" for stage index " + index + " of [0, " + (stages.size() - 1) + "]. These table identifiers are available from previous join stages: " + stages.stream().map(AbstractJoinBuilder::tableIdentifierString).collect(Collectors.joining(", ")));
    }

    private static boolean hasAlias(HasComparableOperators<?, ?> field) {
        return !field.tableAlias().equals(field.identifier().getTableId());
    }

    private static String tableIdentifierString(StageBean<?> stage) {
        if (stage.getField() != null) {
            return AbstractJoinBuilder.tableIdentifierString(stage.getField());
        }
        return AbstractJoinBuilder.tableIdentifierString(stage.getIdentifier());
    }

    private static <T> String tableIdentifierString(TableIdentifier<T> tableIdentifier) {
        return tableIdentifier.getDbmsId() + "." + tableIdentifier.getSchemaId() + "." + tableIdentifier.getTableId();
    }

    private static <T> String tableIdentifierString(HasComparableOperators<T, ?> foreignField) {
        if (AbstractJoinBuilder.hasAlias(foreignField)) {
            return foreignField.tableAlias();
        }
        TableIdentifier tableIdentifier = foreignField.identifier().asTableIdentifier();
        return tableIdentifier.getDbmsId() + "." + tableIdentifier.getSchemaId() + "." + tableIdentifier.getTableId();
    }
}

