/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.join.internal.component.join;

import com.speedment.runtime.field.trait.HasComparableOperators;
import com.speedment.runtime.join.internal.component.join.AbstractJoinBuilder;
import com.speedment.runtime.join.internal.component.join.StageBean;
import com.speedment.runtime.join.stage.JoinOperator;
import com.speedment.runtime.join.trait.HasOnPredicates;
import java.util.Objects;
import java.util.function.BiFunction;

class BaseAfterJoin<T, R>
implements HasOnPredicates<R> {
    private final AbstractJoinBuilder<?, ?> currentBuilderStage;
    private final StageBean<T> stageBean;
    private final BiFunction<AbstractJoinBuilder<?, ?>, StageBean<T>, R> constructor;

    BaseAfterJoin(AbstractJoinBuilder<?, ?> currentBuilderStage, StageBean<T> stageBean, BiFunction<AbstractJoinBuilder<?, ?>, StageBean<T>, R> constructor) {
        this.currentBuilderStage = Objects.requireNonNull(currentBuilderStage);
        this.stageBean = Objects.requireNonNull(stageBean);
        this.constructor = Objects.requireNonNull(constructor);
    }

    @Override
    public R equal(HasComparableOperators<?, ?> joinedField) {
        return this.operation(JoinOperator.EQUAL, joinedField);
    }

    @Override
    public R notEqual(HasComparableOperators<?, ?> joinedField) {
        return this.operation(JoinOperator.NOT_EQUAL, joinedField);
    }

    @Override
    public R lessThan(HasComparableOperators<?, ?> joinedField) {
        return this.operation(JoinOperator.LESS_THAN, joinedField);
    }

    @Override
    public R lessOrEqual(HasComparableOperators<?, ?> joinedField) {
        return this.operation(JoinOperator.LESS_OR_EQUAL, joinedField);
    }

    @Override
    public R greaterThan(HasComparableOperators<?, ?> joinedField) {
        return this.operation(JoinOperator.GREATER_THAN, joinedField);
    }

    @Override
    public R greaterOrEqual(HasComparableOperators<?, ?> joinedField) {
        return this.operation(JoinOperator.GREATER_OR_EQUAL, joinedField);
    }

    private R operation(JoinOperator operatorType, HasComparableOperators<?, ?> joinedField) {
        this.stageBean.setJoinOperator(operatorType);
        this.stageBean.setForeignField(joinedField);
        return this.constructor.apply(this.currentBuilderStage, this.stageBean);
    }
}

