/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.join.internal.component.stream.sql;

import com.speedment.runtime.config.Dbms;
import com.speedment.runtime.config.Project;
import com.speedment.runtime.core.component.DbmsHandlerComponent;
import com.speedment.runtime.core.db.DatabaseNamingConvention;
import com.speedment.runtime.core.db.DbmsType;
import com.speedment.runtime.core.db.FieldPredicateView;
import com.speedment.runtime.core.util.DatabaseUtil;
import com.speedment.runtime.join.internal.component.stream.sql.JoinSqlUtil;
import com.speedment.runtime.join.internal.component.stream.sql.SqlStage;
import com.speedment.runtime.join.stage.Stage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

final class SqlInfo {
    private final Project project;
    private final Dbms dbms;
    private final DbmsType dbmsType;
    private final DatabaseNamingConvention naming;
    private final FieldPredicateView fieldPredicateView;
    private final List<Stage<?>> stages;

    SqlInfo(DbmsHandlerComponent dbmsHandlerComponent, Project project, List<Stage<?>> stages) {
        Objects.requireNonNull(project);
        Objects.requireNonNull(dbmsHandlerComponent);
        this.stages = Objects.requireNonNull(stages);
        this.project = project;
        this.dbms = JoinSqlUtil.requireSameDbms(project, stages);
        this.dbmsType = DatabaseUtil.dbmsTypeOf((DbmsHandlerComponent)dbmsHandlerComponent, (Dbms)this.dbms);
        this.naming = this.dbmsType.getDatabaseNamingConvention();
        this.fieldPredicateView = this.dbmsType.getFieldPredicateView();
    }

    Project project() {
        return this.project;
    }

    Dbms dbms() {
        return this.dbms;
    }

    DbmsType dbmsType() {
        return this.dbmsType;
    }

    DatabaseNamingConvention namingConvention() {
        return this.naming;
    }

    FieldPredicateView fieldPredicateView() {
        return this.fieldPredicateView;
    }

    List<SqlStage> sqlStages() {
        ArrayList<SqlStage> sqlStages = new ArrayList<SqlStage>();
        for (int i = 0; i < this.stages.size(); ++i) {
            sqlStages.add(new SqlStage(this, this.stages.get(i), i));
        }
        return sqlStages;
    }
}

