/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.join.stage;

import java.util.Objects;

public enum JoinOperator {
    EQUAL("=", true),
    NOT_EQUAL("<>", true),
    LESS_THAN("<", false),
    LESS_OR_EQUAL("<=", false),
    GREATER_THAN(">", false),
    GREATER_OR_EQUAL(">=", false);

    private final String operator;
    private final boolean symmetric;

    private JoinOperator(String operator, boolean symmetric) {
        this.operator = Objects.requireNonNull(operator);
        this.symmetric = symmetric;
    }

    public String sqlOperator() {
        return this.operator;
    }

    public boolean isSymmetric() {
        return this.symmetric;
    }

    public JoinOperator swapEquivalent() {
        switch (this) {
            case EQUAL: {
                return EQUAL;
            }
            case NOT_EQUAL: {
                return NOT_EQUAL;
            }
            case LESS_THAN: {
                return GREATER_THAN;
            }
            case LESS_OR_EQUAL: {
                return GREATER_OR_EQUAL;
            }
            case GREATER_THAN: {
                return LESS_THAN;
            }
            case GREATER_OR_EQUAL: {
                return LESS_OR_EQUAL;
            }
        }
        throw new IllegalStateException("There is no swap-equivalent " + JoinOperator.class.getSimpleName() + " to " + (Object)((Object)this));
    }
}

