/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.opensolaris.os.dtrace.Flow;
import org.opensolaris.os.dtrace.ProbeDescription;
import org.opensolaris.os.dtrace.Record;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProbeData
implements Serializable,
Comparable<ProbeData> {
    static final long serialVersionUID = -7021504416192099215L;

    public ProbeData(int enabledProbeID, int cpuID, ProbeDescription p, Flow f, List<Record> recordList) {
    }

    public static Comparator<ProbeData> getComparator(KeyField ... f) {
        return null;
    }

    static int compareUnsigned(int i1, int i2) {
        int cmp = i1 < 0 ? (i2 < 0 ? (i1 < i2 ? -1 : (i1 > i2 ? 1 : 0)) : 1) : (i2 < 0 ? -1 : (i1 < i2 ? -1 : (i1 > i2 ? 1 : 0)));
        return cmp;
    }

    static int compareUnsigned(long i1, long i2) {
        int cmp = i1 < 0L ? (i2 < 0L ? (i1 < i2 ? -1 : (i1 > i2 ? 1 : 0)) : 1) : (i2 < 0L ? -1 : (i1 < i2 ? -1 : (i1 > i2 ? 1 : 0)));
        return cmp;
    }

    static int compareUnsigned(byte i1, byte i2) {
        int cmp = i1 < 0 ? (i2 < 0 ? (i1 < i2 ? -1 : (i1 > i2 ? 1 : 0)) : 1) : (i2 < 0 ? -1 : (i1 < i2 ? -1 : (i1 > i2 ? 1 : 0)));
        return cmp;
    }

    static int compareByteArrays(byte[] a1, byte[] a2) {
        int cmp = 0;
        int len1 = a1.length;
        int len2 = a2.length;
        for (int i = 0; cmp == 0 && i < len1 && i < len2; ++i) {
            cmp = ProbeData.compareUnsigned(a1[i], a2[i]);
        }
        if (cmp == 0) {
            cmp = len1 < len2 ? -1 : (len1 > len2 ? 1 : 0);
        }
        return cmp;
    }

    static int compareUnsigned(Comparable v1, Comparable v2) {
        int cmp;
        if (v1 instanceof Integer) {
            int i1 = (Integer)Integer.class.cast(v1);
            int i2 = (Integer)Integer.class.cast(v2);
            cmp = ProbeData.compareUnsigned(i1, i2);
        } else if (v1 instanceof Long) {
            long i1 = (Long)Long.class.cast(v1);
            long i2 = (Long)Long.class.cast(v2);
            cmp = ProbeData.compareUnsigned(i1, i2);
        } else {
            cmp = v1.compareTo(v2);
        }
        return cmp;
    }

    public int getEnabledProbeID() {
        return -1;
    }

    public int getCPU() {
        return 0;
    }

    public ProbeDescription getEnabledProbeDescription() {
        return null;
    }

    public Flow getFlow() {
        return null;
    }

    public List<Record> getRecords() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public int compareTo(ProbeData d) {
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KeyField {
        CPU,
        PROBE,
        EPID,
        RECORDS;

    }
}

