/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.spi.SerializationProvider;
import com.sun.faces.spi.SerializationProviderFactory;
import com.sun.faces.util.ByteArrayGuardAESCTR;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.lifecycle.ClientWindow;
import javax.servlet.http.HttpSession;

public abstract class StateHelper {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    protected static final char[] STATE_FIELD_START = "<input type=\"hidden\" name=\"javax.faces.ViewState\" id=\"".toCharArray();
    protected static final char[] FIELD_MIDDLE = "\" value=\"".toCharArray();
    protected static final char[] FIELD_END = "\" />".toCharArray();
    protected static final char[] STATE_FIELD_AUTOCOMPLETE_END = "\" autocomplete=\"off\" />".toCharArray();
    protected SerializationProvider serialProvider;
    protected WebConfiguration webConfig;
    protected boolean compressViewState;
    protected char[] stateFieldStart;
    protected char[] fieldMiddle;
    protected char[] fieldEnd;
    protected boolean namespaceParameters;
    private static final String TOKEN_NAME = "com.sun.faces.TOKEN";

    public StateHelper() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        this.serialProvider = SerializationProviderFactory.createInstance(ctx.getExternalContext());
        this.webConfig = WebConfiguration.getInstance(ctx.getExternalContext());
        this.compressViewState = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.CompressViewState);
        this.stateFieldStart = STATE_FIELD_START;
        this.fieldMiddle = FIELD_MIDDLE;
        char[] cArray = this.fieldEnd = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.AutoCompleteOffOnViewState) ? STATE_FIELD_AUTOCOMPLETE_END : FIELD_END;
        if (this.serialProvider == null) {
            this.serialProvider = SerializationProviderFactory.createInstance(FacesContext.getCurrentInstance().getExternalContext());
        }
        this.namespaceParameters = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.NamespaceParameters);
    }

    public static void createAndStoreCryptographicallyStrongTokenInSession(HttpSession session) {
        ByteArrayGuardAESCTR guard = new ByteArrayGuardAESCTR();
        String clearText = "" + System.currentTimeMillis();
        String result = guard.encrypt(clearText);
        try {
            result = URLEncoder.encode(result, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Unable to URL encode cryptographically strong token, storing clear text in session instead.", e);
            }
            result = clearText;
        }
        session.setAttribute(TOKEN_NAME, (Object)result);
    }

    public String getCryptographicallyStrongTokenFromSession(FacesContext context) {
        String result = (String)context.getExternalContext().getSessionMap().get(TOKEN_NAME);
        if (null == result) {
            context.getExternalContext().getSession(true);
        }
        result = (String)context.getExternalContext().getSessionMap().get(TOKEN_NAME);
        return result;
    }

    public abstract void writeState(FacesContext var1, Object var2, StringBuilder var3) throws IOException;

    public abstract Object getState(FacesContext var1, String var2) throws IOException;

    public abstract boolean isStateless(FacesContext var1, String var2) throws IllegalStateException;

    protected static String getStateParamValue(FacesContext context) {
        String pValue = (String)context.getExternalContext().getRequestParameterMap().get("javax.faces.ViewState");
        if (pValue != null && pValue.length() == 0) {
            pValue = null;
        }
        return pValue;
    }

    protected void writeRenderKitIdField(FacesContext context, ResponseWriter writer) throws IOException {
        String result = context.getViewRoot().getRenderKitId();
        String defaultRkit = context.getApplication().getDefaultRenderKitId();
        if (null == defaultRkit) {
            defaultRkit = "HTML_BASIC";
        }
        if (result != null && !defaultRkit.equals(result)) {
            String namingContainerId;
            writer.startElement("input", (UIComponent)context.getViewRoot());
            writer.writeAttribute("type", (Object)"hidden", "type");
            String renderKitIdParam = "javax.faces.RenderKitId";
            UIViewRoot viewRoot = context.getViewRoot();
            if (this.namespaceParameters && viewRoot instanceof NamingContainer && (namingContainerId = viewRoot.getContainerClientId(context)) != null) {
                renderKitIdParam = namingContainerId + renderKitIdParam;
            }
            writer.writeAttribute("name", (Object)renderKitIdParam, "name");
            writer.writeAttribute("value", (Object)result, "value");
            writer.endElement("input");
        }
    }

    protected void writeClientWindowField(FacesContext context, ResponseWriter writer) throws IOException {
        ClientWindow window = context.getExternalContext().getClientWindow();
        if (null != window) {
            String namingContainerId;
            writer.startElement("input", null);
            writer.writeAttribute("type", (Object)"hidden", null);
            String clientWindowParam = "javax.faces.ClientWindow";
            UIViewRoot viewRoot = context.getViewRoot();
            if (this.namespaceParameters && viewRoot instanceof NamingContainer && (namingContainerId = viewRoot.getContainerClientId(context)) != null) {
                clientWindowParam = namingContainerId + clientWindowParam;
            }
            writer.writeAttribute("name", (Object)clientWindowParam, null);
            writer.writeAttribute("id", (Object)Util.getClientWindowId(context), null);
            writer.writeAttribute("value", (Object)window.getId(), null);
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.AutoCompleteOffOnViewState)) {
                writer.writeAttribute("autocomplete", (Object)"off", null);
            }
            writer.endElement("input");
        }
    }
}

