/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.component.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.component.search.ComponentNotFoundException;
import javax.faces.component.search.SearchExpressionContext;
import javax.faces.component.search.SearchExpressionHandler;
import javax.faces.component.search.SearchExpressionHint;
import javax.faces.component.search.SearchKeywordContext;
import javax.faces.component.search.SearchKeywordResolver;
import javax.faces.context.FacesContext;

public class SearchExpressionHandlerImpl
extends SearchExpressionHandler {
    protected void addHint(SearchExpressionContext searchExpressionContext, SearchExpressionHint hint) {
        if (!searchExpressionContext.getExpressionHints().contains(hint)) {
            searchExpressionContext.getExpressionHints().add(hint);
        }
    }

    public String resolveClientId(SearchExpressionContext searchExpressionContext, String expression) {
        String clientId;
        expression = expression == null ? "" : expression.trim();
        this.addHint(searchExpressionContext, SearchExpressionHint.RESOLVE_SINGLE_COMPONENT);
        FacesContext facesContext = searchExpressionContext.getFacesContext();
        SearchExpressionHandler handler = facesContext.getApplication().getSearchExpressionHandler();
        if (!expression.isEmpty() && handler.isPassthroughExpression(searchExpressionContext, expression)) {
            return expression;
        }
        ResolveClientIdCallback internalCallback = new ResolveClientIdCallback();
        if (!expression.isEmpty()) {
            handler.invokeOnComponent(searchExpressionContext, expression, (ContextCallback)internalCallback);
        }
        if ((clientId = internalCallback.getClientId()) == null && !this.isHintSet(searchExpressionContext, SearchExpressionHint.IGNORE_NO_RESULT)) {
            throw new ComponentNotFoundException("Cannot find component for expression \"" + expression + "\" referenced from \"" + searchExpressionContext.getSource().getClientId(facesContext) + "\".");
        }
        return clientId;
    }

    public List<String> resolveClientIds(SearchExpressionContext searchExpressionContext, String expressions) {
        expressions = expressions == null ? "" : expressions.trim();
        FacesContext facesContext = searchExpressionContext.getFacesContext();
        SearchExpressionHandler handler = facesContext.getApplication().getSearchExpressionHandler();
        ResolveClientIdsCallback internalCallback = new ResolveClientIdsCallback();
        if (!expressions.isEmpty()) {
            for (String expression : handler.splitExpressions(facesContext, expressions)) {
                if (handler.isPassthroughExpression(searchExpressionContext, expression)) {
                    internalCallback.addClientId(expression);
                    continue;
                }
                handler.invokeOnComponent(searchExpressionContext, expression, (ContextCallback)internalCallback);
            }
        }
        if (internalCallback.getClientIds() == null && !this.isHintSet(searchExpressionContext, SearchExpressionHint.IGNORE_NO_RESULT)) {
            throw new ComponentNotFoundException("Cannot find component for expressions \"" + expressions + "\" referenced from \"" + searchExpressionContext.getSource().getClientId(facesContext) + "\".");
        }
        List<String> clientIds = internalCallback.getClientIds();
        if (clientIds == null) {
            clientIds = Collections.emptyList();
        }
        return clientIds;
    }

    public void resolveComponent(SearchExpressionContext searchExpressionContext, String expression, ContextCallback callback) {
        if (expression != null) {
            expression = expression.trim();
        }
        this.addHint(searchExpressionContext, SearchExpressionHint.RESOLVE_SINGLE_COMPONENT);
        FacesContext facesContext = searchExpressionContext.getFacesContext();
        SearchExpressionHandler handler = facesContext.getApplication().getSearchExpressionHandler();
        ResolveComponentCallback internalCallback = new ResolveComponentCallback(callback);
        handler.invokeOnComponent(searchExpressionContext, expression, (ContextCallback)internalCallback);
        if (!internalCallback.isInvoked() && !this.isHintSet(searchExpressionContext, SearchExpressionHint.IGNORE_NO_RESULT)) {
            throw new ComponentNotFoundException("Cannot find component for expression \"" + expression + "\" referenced from \"" + searchExpressionContext.getSource().getClientId(facesContext) + "\".");
        }
    }

    public void resolveComponents(SearchExpressionContext searchExpressionContext, String expressions, ContextCallback callback) {
        if (expressions != null) {
            expressions = expressions.trim();
        }
        FacesContext facesContext = searchExpressionContext.getFacesContext();
        SearchExpressionHandler handler = facesContext.getApplication().getSearchExpressionHandler();
        ResolveComponentsCallback internalCallback = new ResolveComponentsCallback(callback);
        if (expressions != null) {
            for (String expression : handler.splitExpressions(facesContext, expressions)) {
                handler.invokeOnComponent(searchExpressionContext, expression, (ContextCallback)internalCallback);
            }
        }
        if (!internalCallback.isInvoked() && !this.isHintSet(searchExpressionContext, SearchExpressionHint.IGNORE_NO_RESULT)) {
            throw new ComponentNotFoundException("Cannot find component for expressions \"" + expressions + "\" referenced from \"" + searchExpressionContext.getSource().getClientId(facesContext) + "\".");
        }
    }

    public void invokeOnComponent(final SearchExpressionContext searchExpressionContext, UIComponent previous, String expression, final ContextCallback callback) {
        if (expression == null || previous == null) {
            return;
        }
        expression = expression.trim();
        FacesContext facesContext = searchExpressionContext.getFacesContext();
        final SearchExpressionHandler handler = facesContext.getApplication().getSearchExpressionHandler();
        if (expression.contains("@")) {
            char separatorChar = facesContext.getNamingContainerSeparatorChar();
            if (expression.charAt(0) == separatorChar && expression.charAt(1) == "@".charAt(0)) {
                handler.invokeOnComponent(searchExpressionContext, (UIComponent)facesContext.getViewRoot(), expression.substring(1), callback);
                return;
            }
            String command = this.extractFirstCommand(facesContext, expression);
            String remainingExpression = null;
            if (command.length() < expression.length()) {
                remainingExpression = expression.substring(command.length() + 1);
            }
            if (command.startsWith("@")) {
                String keyword = command.substring("@".length());
                if (remainingExpression == null) {
                    this.invokeKeywordResolvers(searchExpressionContext, previous, keyword, null, callback);
                } else {
                    if (facesContext.getApplication().getSearchKeywordResolver().isLeaf(searchExpressionContext, keyword)) {
                        throw new FacesException("It's not valid to place a keyword or id after a leaf keyword: @" + keyword + ". Expression: " + expression);
                    }
                    final String finalRemainingExpression = remainingExpression;
                    this.invokeKeywordResolvers(searchExpressionContext, previous, keyword, remainingExpression, new ContextCallback(){

                        public void invokeContextCallback(FacesContext facesContext, UIComponent target) {
                            handler.invokeOnComponent(searchExpressionContext, target, finalRemainingExpression, callback);
                        }
                    });
                }
            } else {
                String id = command;
                UIComponent target = previous.findComponent(id);
                if (target != null) {
                    if (remainingExpression == null) {
                        callback.invokeContextCallback(facesContext, target);
                    } else {
                        handler.invokeOnComponent(searchExpressionContext, target, remainingExpression, callback);
                    }
                }
            }
        } else {
            UIComponent target = previous.findComponent(expression);
            if (target != null) {
                callback.invokeContextCallback(facesContext, target);
            } else if (!this.isHintSet(searchExpressionContext, SearchExpressionHint.SKIP_VIRTUAL_COMPONENTS)) {
                char separatorChar = facesContext.getNamingContainerSeparatorChar();
                if (expression.charAt(0) == separatorChar) {
                    expression = expression.substring(1);
                }
                facesContext.getViewRoot().invokeOnComponent(facesContext, expression, callback);
            }
        }
    }

    protected void invokeKeywordResolvers(SearchExpressionContext searchExpressionContext, UIComponent previous, String keyword, String remainingExpression, ContextCallback callback) {
        SearchKeywordContext searchContext = new SearchKeywordContext(searchExpressionContext, callback, remainingExpression);
        searchExpressionContext.getFacesContext().getApplication().getSearchKeywordResolver().resolve(searchContext, previous, keyword);
    }

    public String[] splitExpressions(FacesContext context, String expressions) {
        char[] charArray;
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        char[] separators = this.getExpressionSeperatorChars(context);
        int parenthesesCounter = 0;
        for (char c : charArray = expressions.toCharArray()) {
            if (c == '(') {
                ++parenthesesCounter;
            }
            if (c == ')') {
                --parenthesesCounter;
            }
            if (parenthesesCounter == 0) {
                boolean isSeparator = false;
                for (char separator : separators) {
                    if (c != separator) continue;
                    isSeparator = true;
                }
                if (isSeparator) {
                    String bufferAsString = buffer.toString().trim();
                    if (bufferAsString.length() > 0) {
                        tokens.add(bufferAsString);
                    }
                    buffer.delete(0, buffer.length());
                    continue;
                }
                buffer.append(c);
                continue;
            }
            buffer.append(c);
        }
        tokens.add(buffer.toString());
        return tokens.toArray(new String[tokens.size()]);
    }

    public boolean isPassthroughExpression(SearchExpressionContext searchExpressionContext, String expression) {
        if (expression != null) {
            expression = expression.trim();
        }
        if (expression != null && expression.contains("@")) {
            FacesContext facesContext = searchExpressionContext.getFacesContext();
            String command = this.extractFirstCommand(facesContext, expression);
            String remainingExpression = null;
            if (command.length() < expression.length()) {
                remainingExpression = expression.substring(command.length() + 1);
            }
            if (command.startsWith("@") && remainingExpression == null) {
                String keyword = command.substring("@".length());
                SearchKeywordResolver keywordResolver = facesContext.getApplication().getSearchKeywordResolver();
                return keywordResolver.isPassthrough(searchExpressionContext, keyword);
            }
            SearchExpressionHandler handler = facesContext.getApplication().getSearchExpressionHandler();
            return handler.isPassthroughExpression(searchExpressionContext, remainingExpression);
        }
        return false;
    }

    public boolean isValidExpression(SearchExpressionContext searchExpressionContext, String expression) {
        if (expression != null) {
            expression = expression.trim();
        }
        if (expression == null || expression.isEmpty()) {
            return true;
        }
        if (expression.contains("@")) {
            FacesContext facesContext = searchExpressionContext.getFacesContext();
            SearchExpressionHandler handler = facesContext.getApplication().getSearchExpressionHandler();
            char separatorChar = facesContext.getNamingContainerSeparatorChar();
            if (expression.charAt(0) == separatorChar) {
                expression = expression.substring(1);
            }
            String command = this.extractFirstCommand(facesContext, expression);
            String remainingExpression = null;
            if (command.length() < expression.length()) {
                remainingExpression = expression.substring(command.length() + 1);
            }
            if (command.startsWith("@")) {
                String keyword = command.substring("@".length());
                SearchKeywordResolver keywordResolver = facesContext.getApplication().getSearchKeywordResolver();
                if (!keywordResolver.isResolverForKeyword(searchExpressionContext, keyword)) {
                    return false;
                }
                if (remainingExpression != null && !remainingExpression.trim().isEmpty()) {
                    if (keywordResolver.isLeaf(searchExpressionContext, keyword)) {
                        return false;
                    }
                    return handler.isValidExpression(searchExpressionContext, remainingExpression);
                }
            } else if (remainingExpression != null) {
                return handler.isValidExpression(searchExpressionContext, remainingExpression);
            }
        }
        return true;
    }

    protected boolean isHintSet(SearchExpressionContext searchExpressionContext, SearchExpressionHint hint) {
        return searchExpressionContext.getExpressionHints().contains(hint);
    }

    protected String extractFirstCommand(FacesContext facesContext, String expression) {
        int parenthesesCounter = -1;
        int count = -1;
        for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (c == '(') {
                if (parenthesesCounter == -1) {
                    parenthesesCounter = 0;
                }
                ++parenthesesCounter;
            }
            if (c == ')') {
                --parenthesesCounter;
            }
            if (parenthesesCounter == 0) {
                count = i + 1;
                break;
            }
            if (parenthesesCounter != -1 || i <= 0 || c != facesContext.getNamingContainerSeparatorChar()) continue;
            count = i;
            break;
        }
        if (count == -1) {
            return expression;
        }
        return expression.substring(0, count);
    }

    private static class ResolveComponentsCallback
    implements ContextCallback {
        private final ContextCallback callback;
        private boolean invoked;

        public ResolveComponentsCallback(ContextCallback callback) {
            this.callback = callback;
            this.invoked = false;
        }

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            this.invoked = true;
            this.callback.invokeContextCallback(context, target);
        }

        public boolean isInvoked() {
            return this.invoked;
        }
    }

    private static class ResolveComponentCallback
    implements ContextCallback {
        private final ContextCallback callback;
        private boolean invoked;

        public ResolveComponentCallback(ContextCallback callback) {
            this.callback = callback;
            this.invoked = false;
        }

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            if (!this.isInvoked()) {
                this.invoked = true;
                this.callback.invokeContextCallback(context, target);
            }
        }

        public boolean isInvoked() {
            return this.invoked;
        }
    }

    private static class ResolveClientIdsCallback
    implements ContextCallback {
        private List<String> clientIds = null;

        private ResolveClientIdsCallback() {
        }

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            this.addClientId(target.getClientId(context));
        }

        public List<String> getClientIds() {
            return this.clientIds;
        }

        public void addClientId(String clientId) {
            if (this.clientIds == null) {
                this.clientIds = new ArrayList<String>();
            }
            this.clientIds.add(clientId);
        }
    }

    private static class ResolveClientIdCallback
    implements ContextCallback {
        private String clientId = null;

        private ResolveClientIdCallback() {
        }

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            if (this.clientId == null) {
                this.clientId = target.getClientId(context);
            }
        }

        public String getClientId() {
            return this.clientId;
        }
    }
}

