/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.lookup.entry;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.rmi.MarshalledObject;
import java.util.Arrays;
import java.util.Comparator;
import net.jini.core.entry.Entry;
import net.jini.lookup.entry.ServiceControlled;

public class LookupAttributes {
    private static final FieldComparator comparator = new FieldComparator();
    private static final Class[] noArg = new Class[0];

    private LookupAttributes() {
    }

    public static Entry[] add(Entry[] attrSets, Entry[] addAttrSets) {
        return LookupAttributes.add(attrSets, addAttrSets, false);
    }

    public static Entry[] add(Entry[] attrSets, Entry[] addAttrSets, boolean checkSC) {
        LookupAttributes.check(addAttrSets, false);
        Entry[] newSets = LookupAttributes.concat(attrSets, addAttrSets);
        int i = newSets.length;
        while (--i >= attrSets.length) {
            if (checkSC) {
                LookupAttributes.check(newSets[i]);
            }
            if (!LookupAttributes.isDup(newSets, i)) continue;
            newSets = LookupAttributes.delete(newSets, i);
        }
        return newSets;
    }

    public static Entry[] modify(Entry[] attrSets, Entry[] attrSetTmpls, Entry[] modAttrSets) {
        return LookupAttributes.modify(attrSets, attrSetTmpls, modAttrSets, false);
    }

    public static Entry[] modify(Entry[] attrSets, Entry[] attrSetTmpls, Entry[] modAttrSets, boolean checkSC) {
        if (attrSetTmpls.length != modAttrSets.length) {
            throw new IllegalArgumentException("attribute set length mismatch");
        }
        int i = modAttrSets.length;
        while (--i >= 0) {
            if (modAttrSets[i] == null || LookupAttributes.isAssignableFrom(modAttrSets[i].getClass(), attrSetTmpls[i].getClass())) continue;
            throw new IllegalArgumentException("attribute set type mismatch");
        }
        LookupAttributes.check(attrSetTmpls, false);
        LookupAttributes.check(modAttrSets, true);
        attrSets = (Entry[])attrSets.clone();
        i = attrSets.length;
        block1: while (--i >= 0) {
            Entry pre = attrSets[i];
            int j = attrSetTmpls.length;
            while (--j >= 0) {
                Entry mods;
                if (!LookupAttributes.matches(attrSetTmpls[j], pre)) continue;
                if (checkSC) {
                    LookupAttributes.check(pre);
                }
                if ((mods = modAttrSets[j]) == null) {
                    attrSets = LookupAttributes.delete(attrSets, i);
                    continue block1;
                }
                attrSets[i] = LookupAttributes.update(attrSets[i], mods);
            }
        }
        i = attrSets.length;
        while (--i >= 0) {
            if (!LookupAttributes.isDup(attrSets, i)) continue;
            attrSets = LookupAttributes.delete(attrSets, i);
        }
        return attrSets;
    }

    public static boolean equal(Entry e1, Entry e2) {
        if (!LookupAttributes.equal(e1.getClass(), e2.getClass())) {
            return false;
        }
        Field[] fields1 = LookupAttributes.getFields(e1);
        Field[] fields2 = LookupAttributes.getFields(e2, e1, fields1);
        try {
            int i = fields1.length;
            while (--i >= 0) {
                if (LookupAttributes.equal(fields1[i].get(e1), fields2[i].get(e2))) continue;
                return false;
            }
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("unexpected IllegalAccessException");
        }
        return true;
    }

    public static boolean equal(Entry[] attrSet1, Entry[] attrSet2) {
        return LookupAttributes.contains(attrSet1, attrSet2) && LookupAttributes.contains(attrSet2, attrSet1);
    }

    public static boolean matches(Entry tmpl, Entry e) {
        if (!LookupAttributes.isAssignableFrom(tmpl.getClass(), e.getClass())) {
            return false;
        }
        Field[] tfields = LookupAttributes.getFields(tmpl);
        Field[] efields = LookupAttributes.getFields(e, tmpl, tfields);
        try {
            int i = tfields.length;
            while (--i >= 0) {
                Object val = tfields[i].get(tmpl);
                if (val == null || LookupAttributes.equal(val, efields[i].get(e))) continue;
                return false;
            }
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("unexpected IllegalAccessException");
        }
        return true;
    }

    public static void check(Entry[] attrs, boolean nullOK) {
        int i = attrs.length;
        while (--i >= 0) {
            Entry e = attrs[i];
            if (e == null && nullOK) continue;
            Class<?> c = e.getClass();
            if (!Modifier.isPublic(c.getModifiers())) {
                throw new IllegalArgumentException("entry class " + c.getName() + " is not public");
            }
            try {
                c.getConstructor(noArg);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalArgumentException("entry class " + c.getName() + " does not have a public no-arg constructor");
            }
            Field[] fields = c.getFields();
            int j = fields.length;
            while (--j >= 0) {
                if ((fields[j].getModifiers() & 0x98) != 0 || !fields[j].getType().isPrimitive()) continue;
                throw new IllegalArgumentException("entry class " + c.getName() + " has a primitive field");
            }
        }
    }

    private static void check(Entry e) {
        if (e instanceof ServiceControlled) {
            throw new SecurityException("attempt to add or modify a ServiceControlled attribute set");
        }
    }

    private static boolean isDup(Entry[] attrs, int index) {
        Entry set = attrs[index];
        int i = index;
        while (--i >= 0) {
            if (!LookupAttributes.equal(set, attrs[i])) continue;
            return true;
        }
        return false;
    }

    private static Entry update(Entry e, Entry mods) {
        try {
            Entry ec = (Entry)e.getClass().newInstance();
            Field[] mfields = LookupAttributes.getFields(mods);
            Field[] efields = LookupAttributes.getFields(e, mods, mfields);
            int i = efields.length;
            while (--i >= 0) {
                efields[i].set(ec, efields[i].get(e));
            }
            i = mfields.length;
            while (--i >= 0) {
                Object val = mfields[i].get(mods);
                if (val == null) continue;
                efields[i].set(ec, val);
            }
            return ec;
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("unexpected InstantiationException");
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("unexpected IllegalAccessException");
        }
    }

    private static boolean equal(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        Class<?> c = o1.getClass();
        if (c == String.class || c == Integer.class || c == Boolean.class || c == Character.class || c == Long.class || c == Float.class || c == Double.class || c == Byte.class || c == Short.class) {
            return o1.equals(o2);
        }
        try {
            return new MarshalledObject<Object>(o1).equals(new MarshalledObject<Object>(o2));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("unexpected IOException");
        }
    }

    private static boolean equal(Class c1, Class c2) {
        return c1.equals(c2) || c1.getName().equals(c2.getName());
    }

    private static boolean isAssignableFrom(Class c1, Class c2) {
        if (c1.isAssignableFrom(c2)) {
            return true;
        }
        String n1 = c1.getName();
        for (Class sup = c2; sup != null; sup = sup.getSuperclass()) {
            if (!n1.equals(sup.getName())) continue;
            return true;
        }
        return false;
    }

    private static Field[] getFields(Entry e) {
        Field[] fields = e.getClass().getFields();
        Arrays.sort(fields, comparator);
        int len = 0;
        for (int i = 0; i < fields.length; ++i) {
            if ((fields[i].getModifiers() & 0x98) != 0) continue;
            fields[len++] = fields[i];
        }
        if (len < fields.length) {
            Field[] nfields = new Field[len];
            System.arraycopy(fields, 0, nfields, 0, len);
            fields = nfields;
        }
        return fields;
    }

    private static Field[] getFields(Entry e, Entry oe, Field[] ofields) {
        if (e.getClass().equals(oe.getClass())) {
            return ofields;
        }
        Field[] fields = LookupAttributes.getFields(e);
        if (fields.length < ofields.length) {
            throw new IllegalArgumentException("type mismatch");
        }
        return fields;
    }

    private static Entry[] concat(Entry[] attrs1, Entry[] attrs2) {
        Entry[] nattrs = new Entry[attrs1.length + attrs2.length];
        System.arraycopy(attrs1, 0, nattrs, 0, attrs1.length);
        System.arraycopy(attrs2, 0, nattrs, attrs1.length, attrs2.length);
        return nattrs;
    }

    private static Entry[] delete(Entry[] attrs, int i) {
        int len = attrs.length - 1;
        Entry[] nattrs = new Entry[len];
        System.arraycopy(attrs, 0, nattrs, 0, i);
        System.arraycopy(attrs, i + 1, nattrs, i, len - i);
        return nattrs;
    }

    private static boolean contains(Entry[] eSet, Entry e) {
        for (int i = 0; i < eSet.length; ++i) {
            if (!LookupAttributes.equal(eSet[i], e)) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(Entry[] eSet1, Entry[] eSet2) {
        int len1 = 0;
        int len2 = 0;
        if (eSet1 != null) {
            len1 = eSet1.length;
        }
        if (eSet2 != null) {
            len2 = eSet2.length;
        }
        if (len1 < len2) {
            return false;
        }
        for (int i = 0; i < len2; ++i) {
            if (LookupAttributes.contains(eSet1, eSet2[i])) continue;
            return false;
        }
        return true;
    }

    private static class FieldComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Field f1 = (Field)o1;
            Field f2 = (Field)o2;
            if (f1 == f2) {
                return 0;
            }
            if (f1.getDeclaringClass() == f2.getDeclaringClass()) {
                return f1.getName().compareTo(f2.getName());
            }
            if (f1.getDeclaringClass().isAssignableFrom(f2.getDeclaringClass())) {
                return -1;
            }
            return 1;
        }
    }
}

