/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.system;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;

public abstract class CommandLine {
    public static String parseString(String str, String defaultValue) {
        return str != null ? str : defaultValue;
    }

    public static int parseInt(String str, int defaultValue) throws NumberFormatException {
        if (str == null) {
            return defaultValue;
        }
        if (str.startsWith("0x")) {
            return Integer.parseInt(str.substring(2), 16);
        }
        if (str.startsWith("#")) {
            return Integer.parseInt(str.substring(1), 16);
        }
        if (str.startsWith("0")) {
            return Integer.parseInt(str.substring(1), 8);
        }
        return Integer.parseInt(str);
    }

    public static long parseLong(String str, long defaultValue) throws NumberFormatException {
        if (str == null) {
            return defaultValue;
        }
        if (str.startsWith("0x")) {
            return Long.parseLong(str.substring(2), 16);
        }
        if (str.startsWith("#")) {
            return Long.parseLong(str.substring(1), 16);
        }
        if (str.startsWith("0")) {
            return Long.parseLong(str.substring(1), 8);
        }
        return Long.parseLong(str);
    }

    public static double parseDouble(String str, double defaultValue) throws NumberFormatException {
        if (str == null) {
            return defaultValue;
        }
        return new Double(str);
    }

    public static Writer parseWriter(String path, Writer defaultValue) throws IOException {
        if (path == null) {
            return defaultValue;
        }
        if (path.equals("-")) {
            return new OutputStreamWriter(System.out);
        }
        return new FileWriter(path);
    }

    public static Writer parseWriter(String path, String defaultPath) throws IOException {
        if (path == null) {
            path = defaultPath;
        }
        if (path.equals("-")) {
            return new OutputStreamWriter(System.out);
        }
        return new FileWriter(path);
    }

    public static Reader parseReader(String path, Reader defaultValue) throws IOException {
        if (path == null) {
            return defaultValue;
        }
        if (path.equals("-")) {
            return new InputStreamReader(System.in);
        }
        return new FileReader(path);
    }

    public static Reader parseReader(String path, String defaultPath) throws IOException {
        if (path == null) {
            path = defaultPath;
        }
        if (path.equals("-")) {
            return new InputStreamReader(System.in);
        }
        return new FileReader(path);
    }

    public static OutputStream parseOutputStream(String path, OutputStream defaultValue) throws IOException {
        if (path == null) {
            return defaultValue;
        }
        if (path.equals("-")) {
            return System.out;
        }
        return new FileOutputStream(path);
    }

    public static OutputStream parseOutputStream(String path, String defaultPath) throws IOException {
        if (path == null) {
            path = defaultPath;
        }
        if (path.equals("-")) {
            return System.out;
        }
        return new FileOutputStream(path);
    }

    public static InputStream parseInputStream(String path, InputStream defaultValue) throws IOException {
        if (path == null) {
            return defaultValue;
        }
        if (path.equals("-")) {
            return System.in;
        }
        return new FileInputStream(path);
    }

    public static InputStream parseInputStream(String path, String defaultPath) throws IOException {
        if (path == null) {
            path = defaultPath;
        }
        if (path.equals("-")) {
            return System.in;
        }
        return new FileInputStream(path);
    }

    public static RandomAccessFile parseRandomAccessFile(String path, RandomAccessFile defaultValue, String mode) throws IOException {
        if (path == null) {
            return defaultValue;
        }
        return new RandomAccessFile(path, mode);
    }

    public static RandomAccessFile parseRandomAccessFile(String path, String defaultPath, String mode) throws IOException {
        if (path == null) {
            path = defaultPath;
        }
        return new RandomAccessFile(path, mode);
    }

    public static class HelpOnlyException
    extends Exception {
        static final long serialVersionUID = -8973201446772368025L;

        public HelpOnlyException() {
            super("User only asked for help");
        }
    }

    public static class BadInvocationException
    extends Exception {
        static final long serialVersionUID = 4503820475450471907L;

        public BadInvocationException(Object opt) {
            super("Argument required for '" + opt + "'");
        }

        public BadInvocationException(String str) {
            super(str);
        }
    }

    public static class ProgrammingException
    extends RuntimeException {
        static final long serialVersionUID = 2401745757311140184L;

        public ProgrammingException(String str) {
            super(str);
        }
    }
}

