/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.system;

import com.sun.jini.system.CommandLine;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;

public class POSIXCommandLine
extends CommandLine {
    private String[] orig;
    private char[][] args;
    private boolean allUsed;
    private boolean singles;
    private boolean usedUp;
    private ArrayList options;
    private String prog;
    private int str;
    private int pos;
    private char opt;
    private static final char USED = '\u0000';

    public POSIXCommandLine(String[] args) {
        this(null, args);
    }

    public POSIXCommandLine(String prog, String[] args) {
        this.orig = args;
        this.args = new char[args.length][];
        this.prog = prog;
        for (int i = 0; i < args.length; ++i) {
            this.args[i] = args[i].toCharArray();
        }
        this.options = new ArrayList();
    }

    public synchronized boolean getBoolean(char opt) {
        this.addOpt(opt, null);
        this.singles = true;
        boolean retval = false;
        while (this.findOpt(opt)) {
            retval = true;
        }
        return retval;
    }

    private String getArgument(char opt) throws CommandLine.BadInvocationException {
        this.assertNoSingles();
        if (this.findOpt(opt)) {
            return this.optArg();
        }
        return null;
    }

    public synchronized String getString(char opt, String defaultValue) throws CommandLine.BadInvocationException {
        this.addOpt(opt, "str");
        return POSIXCommandLine.parseString(this.getArgument(opt), defaultValue);
    }

    public synchronized int getInt(char opt, int defaultValue) throws CommandLine.BadInvocationException, NumberFormatException {
        this.addOpt(opt, "int");
        return POSIXCommandLine.parseInt(this.getArgument(opt), defaultValue);
    }

    public synchronized long getLong(char opt, long defaultValue) throws CommandLine.BadInvocationException, NumberFormatException {
        this.addOpt(opt, "long");
        return POSIXCommandLine.parseLong(this.getArgument(opt), defaultValue);
    }

    public synchronized double getDouble(char opt, double defaultValue) throws CommandLine.BadInvocationException, NumberFormatException {
        this.addOpt(opt, "val");
        return POSIXCommandLine.parseDouble(this.getArgument(opt), defaultValue);
    }

    public synchronized Writer getWriter(char opt, Writer defaultValue) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(opt, "file");
        return POSIXCommandLine.parseWriter(this.getArgument(opt), defaultValue);
    }

    public synchronized Writer getWriter(char opt, String path) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(opt, "file");
        return POSIXCommandLine.parseWriter(this.getArgument(opt), path);
    }

    public synchronized Reader getReader(char opt, Reader defaultValue) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(opt, "file");
        return POSIXCommandLine.parseReader(this.getArgument(opt), defaultValue);
    }

    public synchronized Reader getReader(char opt, String path) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(opt, "file");
        return POSIXCommandLine.parseReader(this.getArgument(opt), path);
    }

    public synchronized OutputStream getOutputStream(char opt, OutputStream defaultValue) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(opt, "file");
        return POSIXCommandLine.parseOutputStream(this.getArgument(opt), defaultValue);
    }

    public synchronized OutputStream getOutputStream(char opt, String path) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(opt, "file");
        return POSIXCommandLine.parseOutputStream(this.getArgument(opt), path);
    }

    public synchronized InputStream getInputStream(char opt, InputStream defaultValue) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(opt, "file");
        return POSIXCommandLine.parseInputStream(this.getArgument(opt), defaultValue);
    }

    public synchronized InputStream getInputStream(char opt, String path) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(opt, "file");
        return POSIXCommandLine.parseInputStream(this.getArgument(opt), path);
    }

    public synchronized RandomAccessFile getRandomAccessFile(char opt, RandomAccessFile defaultValue, String mode) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(opt, "file");
        return POSIXCommandLine.parseRandomAccessFile(this.getArgument(opt), defaultValue, mode);
    }

    public synchronized RandomAccessFile getRandomAccessFile(char opt, String path, String mode) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(opt, "file");
        return POSIXCommandLine.parseRandomAccessFile(this.getArgument(opt), path, mode);
    }

    private void assertNoSingles() {
        this.assertNotUsedUp();
        if (this.singles) {
            throw new CommandLine.ProgrammingException("opts with args must come first");
        }
    }

    private void assertNotUsedUp() {
        if (this.usedUp) {
            throw new CommandLine.ProgrammingException("Command line used up");
        }
    }

    private boolean findOpt(char opt) {
        if (this.allUsed) {
            return false;
        }
        boolean seenUnused = false;
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i][0] != '-') continue;
            if (this.args[i][1] == '-') break;
            for (int j = 1; j < this.args[i].length; ++j) {
                if (this.args[i][j] == opt) {
                    this.str = i;
                    this.pos = j;
                    this.opt = opt;
                    this.args[i][j] = '\u0000';
                    return true;
                }
                if (this.args[i][j] == '\u0000') continue;
                seenUnused = true;
            }
        }
        if (!seenUnused) {
            this.allUsed = true;
        }
        return false;
    }

    private String optArg() throws CommandLine.BadInvocationException {
        if (this.pos + 1 < this.args[this.str].length) {
            for (int i = this.pos + 1; i < this.args[this.str].length; ++i) {
                this.args[this.str][i] = '\u0000';
            }
            return this.orig[this.str].substring(this.pos + 1);
        }
        if (this.str >= this.orig.length) {
            throw new CommandLine.BadInvocationException(new Character(this.opt));
        }
        for (int i = 0; i < this.args[this.str + 1].length; ++i) {
            this.args[this.str + 1][i] = '\u0000';
        }
        return this.orig[this.str + 1];
    }

    public String[] getOperands() throws CommandLine.BadInvocationException, CommandLine.HelpOnlyException {
        int a;
        if (this.getBoolean('?')) {
            this.usage();
            throw new CommandLine.HelpOnlyException();
        }
        StringBuffer unknown = new StringBuffer();
        for (a = 0; a < this.args.length; ++a) {
            if (this.args[a][0] == '\u0000') continue;
            if (this.args[a][0] != '-') break;
            if (this.args[a][1] == '-') {
                ++a;
                break;
            }
            for (int j = 1; j < this.args[a].length; ++j) {
                if (this.args[a][j] == '\u0000') continue;
                unknown.append(this.args[a][j]);
            }
        }
        if (unknown.length() != 0) {
            throw new CommandLine.BadInvocationException("unknown option" + (unknown.length() > 1 ? "s" : "") + ": " + unknown);
        }
        String[] remains = new String[this.args.length - a];
        for (int i = a; i < this.args.length; ++i) {
            remains[i - a] = this.orig[i];
        }
        this.usedUp = true;
        return remains;
    }

    private void addOpt(char opt, String optType) {
        Iterator it = this.options.iterator();
        while (it.hasNext()) {
            Opt o = (Opt)it.next();
            if (o.opt != opt) continue;
            o.multi = true;
            return;
        }
        if (opt != '?') {
            this.options.add(new Opt(opt, optType));
        }
    }

    public void usage() {
        Opt o;
        if (this.prog != null) {
            System.out.print(this.prog);
            System.out.print(' ');
        }
        System.out.print("[-?]");
        boolean seenBool = false;
        Iterator it = this.options.iterator();
        while (it.hasNext()) {
            o = (Opt)it.next();
            if (o.argType != null) continue;
            if (!seenBool) {
                System.out.print(" [-");
            }
            System.out.print(o.opt);
            seenBool = true;
        }
        if (seenBool) {
            System.out.print(']');
        }
        it = this.options.iterator();
        while (it.hasNext()) {
            o = (Opt)it.next();
            if (o.argType == null) continue;
            System.out.print(" [-");
            System.out.print(o.opt);
            System.out.print(' ');
            System.out.print(o.argType);
            System.out.print("]");
            if (!o.multi) continue;
            System.out.print("...");
        }
        System.out.println(" ...");
    }

    private static class Opt {
        char opt;
        String argType;
        boolean multi;

        Opt(char opt, String argType) {
            this.opt = opt;
            this.argType = argType;
        }
    }
}

