/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.thread;

import com.sun.jini.action.GetLongAction;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.NewThreadAction;
import java.security.AccessController;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ThreadPool
implements Executor {
    private static final long idleTimeout = (Long)AccessController.doPrivileged(new GetLongAction("com.sun.jini.thread.idleThreadTimeout", 300000L));
    private static final Logger logger = Logger.getLogger("com.sun.jini.thread.ThreadPool");
    private final ThreadGroup threadGroup;
    private final Object lock = new Object();
    private int idleThreads = 0;
    private final LinkedList queue = new LinkedList();

    ThreadPool(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable runnable, String name) {
        Task task = new Task(runnable, name);
        Object object = this.lock;
        synchronized (object) {
            if (this.queue.size() < this.idleThreads) {
                this.queue.addLast(task);
                this.lock.notify();
                return;
            }
        }
        Thread t = (Thread)AccessController.doPrivileged(new NewThreadAction(this.threadGroup, new Worker(task), name, true));
        t.start();
    }

    private class Worker
    implements Runnable {
        private Task first;

        Worker(Task first) {
            this.first = first;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Task task = this.first;
            this.first = null;
            while (true) {
                try {
                    task.runnable.run();
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, "uncaught exception", t);
                }
                Object object = ThreadPool.this.lock;
                synchronized (object) {
                    if (ThreadPool.this.queue.isEmpty()) {
                        Thread.currentThread().setName("(JSK) Idle");
                        ThreadPool.this.idleThreads++;
                        try {
                            ThreadPool.this.lock.wait(idleTimeout);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            ThreadPool.this.idleThreads--;
                        }
                        if (ThreadPool.this.queue.isEmpty()) {
                            break;
                        }
                    }
                    task = (Task)ThreadPool.this.queue.removeFirst();
                    Thread.currentThread().setName("(JSK) " + task.name);
                }
            }
        }
    }

    private static class Task {
        final Runnable runnable;
        final String name;

        Task(Runnable runnable, String name) {
            this.runnable = runnable;
            this.name = name;
        }
    }
}

