/*
 * Copyright (C) 2004-2011
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.sun.tools.rngom.parse.host;

import com.sun.tools.rngom.ast.builder.CommentList;
import com.sun.tools.rngom.ast.om.Location;
import com.sun.tools.rngom.ast.builder.BuildException;

/**
 * 
 * @author
 *      Kohsuke Kawaguchi (kk@kohsuke.org)
 */
class CommentListHost extends Base implements CommentList {

    final CommentList lhs;
    final CommentList rhs;

    CommentListHost(CommentList lhs, CommentList rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }
    
    public void addComment(String value, Location _loc) throws BuildException {
        LocationHost loc = cast(_loc);
        if(lhs!=null)
            lhs.addComment(value,loc.lhs);
        if(rhs!=null)
            rhs.addComment(value,loc.rhs);
    }
}
