/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge;

import com.thoughtworks.gauge.ClassInstanceManager;
import com.thoughtworks.gauge.screenshot.ScreenshotFactory;
import java.util.ArrayList;
import java.util.List;

public class Gauge {
    private static final ThreadLocal<List<String>> MESSAGES = new InheritableThreadLocal<List<String>>(){

        @Override
        protected List<String> initialValue() {
            return new ArrayList<String>();
        }
    };
    private static ClassInstanceManager instanceManager;
    private static final ThreadLocal<List<String>> SCREENSHOTS;

    public static void setInstanceManager(ClassInstanceManager instanceManager) {
        Gauge.instanceManager = instanceManager;
    }

    public static void writeMessage(String message) {
        Gauge.getMessages().add(message);
    }

    public static void writeMessage(String format, String ... args) {
        Gauge.getMessages().add(String.format(format, args));
    }

    static List<String> getMessages() {
        return MESSAGES.get();
    }

    public static void captureScreenshot() {
        String screenshotFileName = new ScreenshotFactory(instanceManager).getScreenshotBytes();
        Gauge.getScreenshots().add(screenshotFileName);
    }

    static List<String> getScreenshots() {
        return SCREENSHOTS.get();
    }

    static {
        SCREENSHOTS = new InheritableThreadLocal<List<String>>(){

            @Override
            protected List<String> initialValue() {
                return new ArrayList<String>();
            }
        };
    }
}

