/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.gauge.Util;

public class Logger {
    public static void info(String message) {
        Logger.logToStdout("info", message);
    }

    public static void error(String message) {
        Logger.logToStdErr("error", message);
    }

    public static void error(String message, Throwable t) {
        Logger.error(String.format("%s\n%s\n%s", message, t.getMessage(), Util.stacktraceFrom(t)));
    }

    public static void warning(String message) {
        Logger.logToStdout("warning", message);
    }

    public static void warning(String message, Throwable t) {
        Logger.warning(String.format("%s\n%s\n%s", message, t.getMessage(), Util.stacktraceFrom(t)));
    }

    public static void debug(String message) {
        Logger.logToStdout("debug", message);
    }

    public static void fatal(String message) {
        Logger.logToStdErr("fatal", message);
        System.exit(1);
    }

    public static void fatal(String message, Throwable t) {
        Logger.fatal(String.format("%s\n%s\n%s", message, t.getMessage(), Util.stacktraceFrom(t)));
    }

    private static void logToStdout(String level, String message) {
        System.out.println(LogMessage.of(level, message));
    }

    private static void logToStdErr(String level, String message) {
        System.err.println(LogMessage.of(level, message));
    }

    private record LogMessage(@Expose @SerializedName(value="logLevel") String level, @Expose @SerializedName(value="message") String message) {
        private static final Gson GSON = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

        public static LogMessage of(String level, String message) {
            return new LogMessage(level, message);
        }

        @Override
        public String toString() {
            return GSON.toJson((Object)this);
        }
    }
}

