/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.thoughtworks.gauge.RowSizeMismatchException;
import com.thoughtworks.gauge.TableRow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class Table {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String DASH = "-";
    private static final String PIPE = "|";
    private static final char SPACE_AS_CHAR = ' ';
    private final List<String> headers;
    private final List<List<String>> rows = new ArrayList<List<String>>();
    private final List<TableRow> tableRows = new ArrayList<TableRow>();

    public Table(List<String> headers) {
        this.headers = headers;
    }

    public void addRow(List<String> row) {
        if (row.size() != this.headers.size()) {
            throw new RowSizeMismatchException(String.format("Row size mismatch. Expected row size: %d. Obtained row size: %d.", this.headers.size(), row.size()));
        }
        this.rows.add(row);
        TableRow rowToAdd = new TableRow();
        for (String header : this.headers) {
            rowToAdd.addCell(header, row.get(this.headers.indexOf(header)));
        }
        this.tableRows.add(rowToAdd);
    }

    public List<String> getColumnNames() {
        return this.headers;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.getColumnNames().size()) {
            throw new IndexOutOfBoundsException(String.format("Column with index %d not found. Actual column size: %d.", columnIndex, this.getColumnNames().size()));
        }
        return this.getColumnNames().get(columnIndex);
    }

    public List<TableRow> getTableRows() {
        return this.tableRows;
    }

    public List<String> getColumnValues(String columnName) {
        int columnIndex = this.headers.indexOf(columnName);
        return this.getColumnValues(columnIndex);
    }

    public List<String> getColumnValues(int columnIndex) {
        if (columnIndex >= 0) {
            return this.rows.stream().map(row -> (String)row.get(columnIndex)).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public String toString() {
        int maxStringLength = this.getMaxStringLength();
        if (maxStringLength >= 0) {
            return this.formatAsMarkdownTable(maxStringLength);
        }
        return "";
    }

    private String formatAsMarkdownTable(int maxStringLength) {
        ArrayList<String> formattedHeaderAndRows = new ArrayList<String>();
        this.addHeader(maxStringLength, formattedHeaderAndRows);
        this.addDashes(maxStringLength, formattedHeaderAndRows);
        this.addValues(maxStringLength, formattedHeaderAndRows);
        return Joiner.on((String)LINE_SEPARATOR).join(formattedHeaderAndRows);
    }

    private void addDashes(int maxStringLength, List<String> formattedHeaderAndRows) {
        String dashesString = Joiner.on((String)"").join(Collections.nCopies(maxStringLength, DASH));
        List<String> dashes = Collections.nCopies(this.headers.size(), dashesString);
        String formattedDashes = this.formattedRow(dashes, maxStringLength);
        formattedHeaderAndRows.add(formattedDashes);
    }

    private void addHeader(int maxStringLength, List<String> formattedHeaderAndRows) {
        String formattedHeaders = this.formattedRow(this.headers, maxStringLength);
        formattedHeaderAndRows.add(formattedHeaders);
    }

    private void addValues(int maxStringLength, List<String> formattedHeaderAndRows) {
        this.tableRows.stream().map(tableRow -> this.formattedRow(tableRow.getCellValues(), maxStringLength)).forEach(formattedHeaderAndRows::add);
    }

    private String formattedRow(List<String> strings, int maxStringLength) {
        List<String> formattedStrings = strings.stream().map(s -> Strings.padEnd((String)s, (int)maxStringLength, (char)' ')).toList();
        return PIPE + Joiner.on((String)PIPE).join(formattedStrings) + PIPE;
    }

    private Integer getMaxStringLength() {
        ArrayList<Integer> maxs = new ArrayList<Integer>();
        maxs.add(this.getMaxStringSize(this.headers));
        for (TableRow tableRow : this.tableRows) {
            maxs.add(this.getMaxStringSize(tableRow.getCellValues()));
        }
        return (Integer)Collections.max(maxs);
    }

    private int getMaxStringSize(List<String> candidates) {
        if (candidates == null || candidates.isEmpty()) {
            return -1;
        }
        return Collections.max(candidates, this.maxStringLength()).length();
    }

    private Comparator<String> maxStringLength() {
        return Comparator.comparingInt(String::length);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        result = 31 * result + this.rows.hashCode();
        result = 31 * result + this.tableRows.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Table other = (Table)obj;
        return this.headers.equals(other.getColumnNames()) && this.tableRows.equals(other.getTableRows());
    }
}

