/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.scan;

import com.thoughtworks.gauge.ClassInitializer;
import com.thoughtworks.gauge.DefaultClassInitializer;
import com.thoughtworks.gauge.Logger;
import com.thoughtworks.gauge.registry.ClassInitializerRegistry;
import com.thoughtworks.gauge.scan.IScanner;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.reflections.Reflections;

public class CustomClassInitializerScanner
implements IScanner {
    @Override
    public void scan(Reflections reflections) {
        this.scanForInitializer(reflections);
    }

    private void scanForInitializer(Reflections reflections) {
        Set initializers = reflections.getSubTypesOf(ClassInitializer.class);
        initializers.remove(DefaultClassInitializer.class);
        if (initializers.size() == 1) {
            Class initializer = (Class)initializers.iterator().next();
            try {
                ClassInitializerRegistry.classInitializer((ClassInitializer)initializer.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                Logger.debug(String.format("Using %s as class initializer", initializer.getName()));
            }
            catch (InstantiationException e) {
                Logger.error(String.format("Could not instantiate %s, continuing using default class initializer", initializer.getName()));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                Logger.error(String.format("Could not access %s constructor, continuing using default class initializer", initializer.getName()));
            }
            catch (InvocationTargetException e) {
                Logger.error(String.format("%s's default constructor threw an error [%s], continuing using default class initializer", initializer.getName(), e));
                throw new RuntimeException(e);
            }
        }
        if (initializers.size() > 1) {
            Logger.warning("Multiple class initializers found, switching to default.");
        }
    }
}

