/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.screenshot;

import com.thoughtworks.gauge.ClassInstanceManager;
import com.thoughtworks.gauge.Logger;
import com.thoughtworks.gauge.screenshot.CustomScreenshotWriter;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.file.Path;
import java.util.UUID;
import javax.imageio.ImageIO;

public class ScreenshotFactory {
    public static final String IMAGE_EXTENSION = "png";
    private static volatile Class<? extends CustomScreenshotWriter> customScreenshotWriter;
    private final ClassInstanceManager manager;

    public ScreenshotFactory(ClassInstanceManager manager) {
        this.manager = manager;
    }

    static void setCustomScreenshotGrabber(Class<? extends CustomScreenshotWriter> writerClass) {
        customScreenshotWriter = writerClass;
    }

    public String getScreenshotBytes() {
        return this.takeScreenshot();
    }

    private String takeScreenshot() {
        if (customScreenshotWriter != null) {
            try {
                Object object = this.manager.get(customScreenshotWriter);
                if (object instanceof CustomScreenshotWriter) {
                    CustomScreenshotWriter writer = (CustomScreenshotWriter)object;
                    return writer.takeScreenshot();
                }
            }
            catch (Exception e) {
                Logger.error(String.format("Failed to take Custom screenshot: %s : %s", customScreenshotWriter.getCanonicalName(), e.getMessage()));
                Logger.warning("Capturing regular screenshot..");
            }
        }
        return this.captureScreen();
    }

    private File generateUniqueScreenshotFile() {
        String fileName = String.format("screenshot-%s.%s", UUID.randomUUID().toString(), IMAGE_EXTENSION);
        Path path = Path.of(System.getenv("gauge_screenshots_dir"), fileName);
        return new File(path.toAbsolutePath().toString());
    }

    private String captureScreen() {
        File file = this.generateUniqueScreenshotFile();
        try {
            Rectangle screenRect = new Rectangle(0, 0, 0, 0);
            for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                screenRect = screenRect.union(gd.getDefaultConfiguration().getBounds());
            }
            BufferedImage image = new Robot().createScreenCapture(screenRect);
            ImageIO.write((RenderedImage)image, IMAGE_EXTENSION, file);
        }
        catch (Throwable e) {
            Logger.error("Failed to take regular screenshot: " + e.getMessage());
        }
        return file.getName();
    }
}

