/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit.internal;

import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.junit.internal.ArchTestExecution;
import com.tngtech.archunit.junit.internal.ArchTestInitializationException;
import com.tngtech.archunit.junit.internal.DisplayNameResolver;
import com.tngtech.archunit.junit.internal.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.junit.runner.Description;

class ArchTestMethodExecution
extends ArchTestExecution {
    private final Method testMethod;

    ArchTestMethodExecution(Class<?> testClass, Method testMethod, boolean ignore) {
        super(testClass, ignore);
        this.testMethod = testMethod;
    }

    @Override
    ArchTestExecution.Result evaluateOn(JavaClasses classes) {
        try {
            this.executeTestMethod(classes);
            return new ArchTestExecution.PositiveResult();
        }
        catch (Throwable failure) {
            return new ArchTestExecution.NegativeResult(this.describeSelf(), failure);
        }
    }

    private void executeTestMethod(JavaClasses classes) {
        ArchTestInitializationException.check(Arrays.equals(this.testMethod.getParameterTypes(), new Class[]{JavaClasses.class}), "Methods annotated with @%s must have exactly one parameter of type %s", ArchTest.class.getSimpleName(), JavaClasses.class.getSimpleName());
        ReflectionUtils.invokeMethod(this.testMethod, this.testClass, classes);
    }

    @Override
    Description describeSelf() {
        return Description.createTestDescription((Class)this.testClass, (String)DisplayNameResolver.determineDisplayName(this.testMethod.getName()), (Annotation[])this.testMethod.getAnnotations());
    }

    @Override
    String getName() {
        return this.testMethod.getName();
    }
}

