/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.pojos.pagecollections;

import com.trivago.cluecumber.json.pojo.Report;
import com.trivago.cluecumber.json.pojo.Step;
import com.trivago.cluecumber.rendering.pages.pojos.ResultCount;
import com.trivago.cluecumber.rendering.pages.pojos.Times;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.ScenarioSummaryPageCollection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AllStepsPageCollection
extends ScenarioSummaryPageCollection {
    private Map<Step, ResultCount> stepResultCounts = new HashMap<Step, ResultCount>();
    private Map<Step, Times> stepTimes = new HashMap<Step, Times>();

    public AllStepsPageCollection(List<Report> reports, String pageTitle) {
        super(pageTitle);
        this.calculateStepResultCounts(reports);
    }

    public Map<Step, ResultCount> getStepResultCounts() {
        return this.stepResultCounts;
    }

    public Set<Step> getSteps() {
        return this.stepResultCounts.keySet();
    }

    public int getTotalNumberOfSteps() {
        return this.stepResultCounts.size();
    }

    public String getMinimumTimeFromStep(Step step) {
        return this.stepTimes.get(step).getMinimumTimeString();
    }

    public int getMinimumTimeScenarioIndexFromStep(Step step) {
        return this.stepTimes.get(step).getMinimumTimeScenarioIndex();
    }

    public String getMaximumTimeFromStep(Step step) {
        return this.stepTimes.get(step).getMaximumTimeString();
    }

    public int getMaximumTimeScenarioIndexFromStep(Step step) {
        return this.stepTimes.get(step).getMaximumTimeScenarioIndex();
    }

    public String getAverageTimeFromStep(Step step) {
        return this.stepTimes.get(step).getAverageTimeString();
    }

    private void calculateStepResultCounts(List<Report> reports) {
        if (reports == null) {
            return;
        }
        reports.forEach(report -> report.getElements().forEach(element -> {
            int scenarioIndex = element.getScenarioIndex();
            element.getSteps().forEach(step -> {
                ResultCount stepResultCount = this.stepResultCounts.getOrDefault(step, new ResultCount());
                this.updateResultCount(stepResultCount, step.getStatus());
                this.stepResultCounts.put((Step)step, stepResultCount);
                this.addScenarioIndexByStatus(element.getStatus(), element.getScenarioIndex());
                Times stepTimes = this.stepTimes.getOrDefault(step, new Times());
                if (!step.isSkipped()) {
                    stepTimes.addTime(step.getResult().getDuration(), scenarioIndex);
                }
                this.stepTimes.put((Step)step, stepTimes);
            });
        }));
    }
}

