/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.visitors;

import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.filesystem.FileIO;
import com.trivago.cluecumber.properties.PropertyManager;
import com.trivago.cluecumber.rendering.pages.pojos.Feature;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.AllFeaturesPageCollection;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.AllScenariosPageCollection;
import com.trivago.cluecumber.rendering.pages.renderering.AllFeaturesPageRenderer;
import com.trivago.cluecumber.rendering.pages.renderering.AllScenariosPageRenderer;
import com.trivago.cluecumber.rendering.pages.templates.TemplateEngine;
import com.trivago.cluecumber.rendering.pages.visitors.PageVisitor;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FeatureVisitor
implements PageVisitor {
    private final FileIO fileIO;
    private final TemplateEngine templateEngine;
    private final PropertyManager propertyManager;
    private final AllFeaturesPageRenderer allFeaturesPageRenderer;
    private final AllScenariosPageRenderer allScenariosPageRenderer;

    @Inject
    public FeatureVisitor(FileIO fileIO, TemplateEngine templateEngine, PropertyManager propertyManager, AllFeaturesPageRenderer allFeaturesPageRenderer, AllScenariosPageRenderer allScenariosPageRenderer) {
        this.fileIO = fileIO;
        this.templateEngine = templateEngine;
        this.propertyManager = propertyManager;
        this.allFeaturesPageRenderer = allFeaturesPageRenderer;
        this.allScenariosPageRenderer = allScenariosPageRenderer;
    }

    @Override
    public void visit(AllScenariosPageCollection allScenariosPageCollection) throws CluecumberPluginException {
        AllFeaturesPageCollection allFeaturesPageCollection = new AllFeaturesPageCollection(allScenariosPageCollection.getReports(), this.propertyManager.getCustomPageTitle());
        this.fileIO.writeContentToFile(this.allFeaturesPageRenderer.getRenderedContent(allFeaturesPageCollection, this.templateEngine.getTemplate(TemplateEngine.Template.ALL_FEATURES)), this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "pages" + "/" + "feature-summary" + ".html");
        for (Feature feature : allFeaturesPageCollection.getFeatures()) {
            this.fileIO.writeContentToFile(this.allScenariosPageRenderer.getRenderedContentByFeatureFilter(allScenariosPageCollection, this.templateEngine.getTemplate(TemplateEngine.Template.ALL_SCENARIOS), feature), this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "pages" + "/feature-scenarios/feature_" + feature.getIndex() + ".html");
        }
    }
}

