/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.visitors;

import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.filesystem.FileIO;
import com.trivago.cluecumber.json.pojo.Tag;
import com.trivago.cluecumber.properties.PropertyManager;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.AllScenariosPageCollection;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.AllTagsPageCollection;
import com.trivago.cluecumber.rendering.pages.renderering.AllScenariosPageRenderer;
import com.trivago.cluecumber.rendering.pages.renderering.AllTagsPageRenderer;
import com.trivago.cluecumber.rendering.pages.templates.TemplateEngine;
import com.trivago.cluecumber.rendering.pages.visitors.PageVisitor;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TagVisitor
implements PageVisitor {
    private final FileIO fileIO;
    private final TemplateEngine templateEngine;
    private final PropertyManager propertyManager;
    private final AllTagsPageRenderer allTagsPageRenderer;
    private final AllScenariosPageRenderer allScenariosPageRenderer;

    @Inject
    public TagVisitor(FileIO fileIO, TemplateEngine templateEngine, PropertyManager propertyManager, AllTagsPageRenderer allTagsPageRenderer, AllScenariosPageRenderer allScenariosPageRenderer) {
        this.fileIO = fileIO;
        this.templateEngine = templateEngine;
        this.propertyManager = propertyManager;
        this.allTagsPageRenderer = allTagsPageRenderer;
        this.allScenariosPageRenderer = allScenariosPageRenderer;
    }

    @Override
    public void visit(AllScenariosPageCollection allScenariosPageCollection) throws CluecumberPluginException {
        AllTagsPageCollection allTagsPageCollection = new AllTagsPageCollection(allScenariosPageCollection.getReports(), this.propertyManager.getCustomPageTitle());
        this.fileIO.writeContentToFile(this.allTagsPageRenderer.getRenderedContent(allTagsPageCollection, this.templateEngine.getTemplate(TemplateEngine.Template.ALL_TAGS)), this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "pages" + "/" + "tag-summary" + ".html");
        for (Tag tag : allTagsPageCollection.getTags()) {
            this.fileIO.writeContentToFile(this.allScenariosPageRenderer.getRenderedContentByTagFilter(allScenariosPageCollection, this.templateEngine.getTemplate(TemplateEngine.Template.ALL_SCENARIOS), tag), this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "pages" + "/tag-scenarios/tag_" + tag.getUrlFriendlyName() + ".html");
        }
    }
}

