/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.server.communication.AtmospherePushConnection;
import java.io.Serializable;
import java.util.Optional;
import org.atmosphere.cache.BroadcastMessage;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceSession;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.PerRequestBroadcastFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongPollingCacheFilter
implements PerRequestBroadcastFilter,
Serializable {
    public static final String SEEN_SERVER_SYNC_ID = "X-Vaadin-LastSeenServerSyncId";

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)LongPollingCacheFilter.class.getName());
    }

    static void onConnect(AtmosphereResource resource) {
        Integer syncId = Optional.ofNullable(resource.getRequest().getHeader(SEEN_SERVER_SYNC_ID)).map(Integer::parseInt).orElse(null);
        if (resource.transport() == AtmosphereResource.TRANSPORT.LONG_POLLING && syncId != null) {
            AtmosphereResourceSession session = resource.getAtmosphereConfig().sessionFactory().getSession(resource);
            session.setAttribute(SEEN_SERVER_SYNC_ID, (Object)syncId);
        }
    }

    public BroadcastFilter.BroadcastAction filter(String broadcasterId, AtmosphereResource r, Object originalMessage, Object message) {
        AtmosphereResourceSession session = r.getAtmosphereConfig().sessionFactory().getSession(r, false);
        if (originalMessage instanceof AtmospherePushConnection.PushMessage && r.transport() == AtmosphereResource.TRANSPORT.LONG_POLLING && session != null && session.getAttribute(SEEN_SERVER_SYNC_ID) != null) {
            AtmospherePushConnection.PushMessage pushMessage = (AtmospherePushConnection.PushMessage)originalMessage;
            String uuid = r.uuid();
            int lastSeenOnClient = (Integer)session.getAttribute(SEEN_SERVER_SYNC_ID, Integer.class);
            if (lastSeenOnClient == -1) {
                return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.CONTINUE, message);
            }
            if (pushMessage.alreadySeen(lastSeenOnClient)) {
                LongPollingCacheFilter.getLogger().trace("Discarding message {} for resource {} as client already seen {}. {}", new Object[]{pushMessage.serverSyncId, uuid, lastSeenOnClient, pushMessage.message});
                return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.ABORT, message);
            }
            LongPollingCacheFilter.getLogger().trace("Put message {} for resource {} back to the cache because it may not have reached the client, as the last seen message is {}. {}", new Object[]{pushMessage.serverSyncId, uuid, lastSeenOnClient, pushMessage.message});
            BroadcasterCache cache = r.getBroadcaster().getBroadcasterConfig().getBroadcasterCache();
            cache.addToCache(broadcasterId, uuid, new BroadcastMessage(originalMessage));
        }
        return new BroadcastFilter.BroadcastAction(message);
    }

    public BroadcastFilter.BroadcastAction filter(String broadcasterId, Object originalMessage, Object message) {
        return new BroadcastFilter.BroadcastAction(message);
    }
}

