/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.base.devserver.DebugWindowMessage;
import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.base.devserver.DevToolsMessageHandler;
import com.vaadin.base.devserver.FeatureFlagMessage;
import com.vaadin.base.devserver.IdeIntegration;
import com.vaadin.base.devserver.ProductAndMessage;
import com.vaadin.base.devserver.ServerInfo;
import com.vaadin.base.devserver.stats.DevModeUsageStatistics;
import com.vaadin.base.devserver.themeeditor.ThemeEditorMessageHandler;
import com.vaadin.base.devserver.themeeditor.messages.BaseResponse;
import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.DevToolsToken;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.AtmospherePushConnection;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.Product;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.atmosphere.cpr.AtmosphereResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugWindowConnection
implements BrowserLiveReload {
    private final ClassLoader classLoader;
    private VaadinContext context;
    private final ConcurrentHashMap<WeakReference<AtmosphereResource>, AtmospherePushConnection.FragmentedMessage> resources = new ConcurrentHashMap();
    private BrowserLiveReload.Backend backend = null;
    private static final EnumMap<BrowserLiveReload.Backend, List<String>> IDENTIFIER_CLASSES = new EnumMap(BrowserLiveReload.Backend.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private IdeIntegration ideIntegration;
    private ThemeEditorMessageHandler themeEditorMessageHandler;
    private List<DevToolsMessageHandler> plugins;

    DebugWindowConnection(VaadinContext context) {
        this(DebugWindowConnection.class.getClassLoader(), context);
    }

    DebugWindowConnection(ClassLoader classLoader, VaadinContext context) {
        this.classLoader = classLoader;
        this.context = context;
        this.ideIntegration = new IdeIntegration(ApplicationConfiguration.get((VaadinContext)context));
        this.themeEditorMessageHandler = new ThemeEditorMessageHandler(context);
        this.findPlugins();
    }

    private void findPlugins() {
        ServiceLoader<DevToolsMessageHandler> loader = ServiceLoader.load(DevToolsMessageHandler.class, this.classLoader);
        this.plugins = new ArrayList<DevToolsMessageHandler>();
        for (DevToolsMessageHandler s : loader) {
            this.plugins.add(s);
        }
    }

    public BrowserLiveReload.Backend getBackend() {
        if (this.backend != null) {
            return this.backend;
        }
        for (Map.Entry<BrowserLiveReload.Backend, List<String>> entry : IDENTIFIER_CLASSES.entrySet()) {
            BrowserLiveReload.Backend backendCandidate = entry.getKey();
            boolean found = true;
            for (String clazz : entry.getValue()) {
                try {
                    this.classLoader.loadClass(clazz);
                }
                catch (ClassNotFoundException e) {
                    DebugWindowConnection.getLogger().debug("Class {} not found, excluding {}", (Object)clazz, (Object)backendCandidate);
                    found = false;
                    break;
                }
            }
            if (!found) continue;
            this.backend = backendCandidate;
            break;
        }
        return this.backend;
    }

    public void setBackend(BrowserLiveReload.Backend backend) {
        assert (backend != null);
        this.backend = backend;
    }

    protected DevToolsInterface getDevToolsInterface(AtmosphereResource resource) {
        return new DevToolsInterfaceImpl(this, resource);
    }

    public void onConnect(AtmosphereResource resource) {
        if (DevToolsToken.getToken().equals(resource.getRequest().getParameter("token"))) {
            this.handleConnect(resource);
        } else {
            DebugWindowConnection.getLogger().warn("Connection denied because of a missing or invalid token. The host is probably not on the allow list");
            try {
                resource.close();
            }
            catch (IOException e) {
                DebugWindowConnection.getLogger().debug("Error closing the denied websocket connection", (Throwable)e);
            }
        }
    }

    private void handleConnect(AtmosphereResource resource) {
        resource.suspend(-1L);
        this.resources.put(new WeakReference<AtmosphereResource>(resource), new AtmospherePushConnection.FragmentedMessage());
        resource.getBroadcaster().broadcast((Object)"{\"command\": \"hello\"}", resource);
        for (DevToolsMessageHandler plugin : this.plugins) {
            plugin.handleConnect(this.getDevToolsInterface(resource));
        }
        this.send(resource, "serverInfo", new ServerInfo());
        this.send(resource, "featureFlags", new FeatureFlagMessage(FeatureFlags.get((VaadinContext)this.context).getFeatures().stream().filter(feature -> !feature.equals((Object)FeatureFlags.EXAMPLE)).collect(Collectors.toList())));
        if (this.themeEditorMessageHandler.isEnabled()) {
            this.send(resource, "themeEditorState", this.themeEditorMessageHandler.getState());
        }
    }

    private void send(AtmosphereResource resource, String command, Object data) {
        try {
            this.send(resource, this.objectMapper.writeValueAsString((Object)new DebugWindowMessage(command, data)));
        }
        catch (Exception e) {
            DebugWindowConnection.getLogger().error("Error sending message", (Throwable)e);
        }
    }

    private void send(AtmosphereResource resource, String json) {
        resource.getBroadcaster().broadcast((Object)json, resource);
    }

    public void onDisconnect(AtmosphereResource resource) {
        for (DevToolsMessageHandler plugin : this.plugins) {
            plugin.handleDisconnect(this.getDevToolsInterface(resource));
        }
        if (!this.resources.keySet().removeIf(resourceRef -> resource.equals(resourceRef.get()))) {
            String uuid = resource.uuid();
            DebugWindowConnection.getLogger().warn("Push connection {} is not a live-reload connection or already closed", (Object)uuid);
        }
    }

    public boolean isLiveReload(AtmosphereResource resource) {
        return this.getRef(resource) != null;
    }

    private void send(JsonObject msg) {
        ((ConcurrentHashMap.KeySetView)this.resources.keySet()).forEach(resourceRef -> {
            AtmosphereResource resource = (AtmosphereResource)resourceRef.get();
            if (resource != null) {
                resource.getBroadcaster().broadcast((Object)msg.toJson(), resource);
            }
        });
    }

    public void reload() {
        JsonObject msg = Json.createObject();
        msg.put("command", "reload");
        this.send(msg);
    }

    public void update(String path, String content) {
        JsonObject msg = Json.createObject();
        msg.put("command", "update");
        msg.put("path", path);
        msg.put("content", content);
        this.send(msg);
    }

    public void onMessage(AtmosphereResource resource, String message) {
        if (message.isEmpty()) {
            DebugWindowConnection.getLogger().debug("Received live reload heartbeat");
            return;
        }
        JsonObject json = Json.parse((String)message);
        String command = json.getString("command");
        JsonObject data = json.getObject("data");
        if ("setFeature".equals(command)) {
            FeatureFlags.get((VaadinContext)this.context).setEnabled(data.getString("featureId"), data.getBoolean("enabled"));
        } else if ("reportTelemetry".equals(command)) {
            DevModeUsageStatistics.handleBrowserData(data);
        } else if ("checkLicense".equals(command)) {
            boolean ok;
            String name = data.getString("name");
            String version = data.getString("version");
            Product product = new Product(name, version);
            String errorMessage = "";
            try {
                LicenseChecker.checkLicense((String)product.getName(), (String)product.getVersion(), (BuildType)BuildType.DEVELOPMENT, keyUrl -> this.send(resource, "license-check-nokey", new ProductAndMessage(product, (String)keyUrl)));
                ok = true;
            }
            catch (Exception e) {
                ok = false;
                errorMessage = e.getMessage();
            }
            if (ok) {
                this.send(resource, "license-check-ok", product);
            } else {
                ProductAndMessage pm = new ProductAndMessage(product, errorMessage);
                this.send(resource, "license-check-failed", pm);
            }
        } else if ("showComponentCreateLocation".equals(command) || "showComponentAttachLocation".equals(command)) {
            int nodeId = (int)data.getNumber("nodeId");
            int uiId = (int)data.getNumber("uiId");
            VaadinSession session = VaadinSession.getCurrent();
            session.access((Command & Serializable)() -> {
                Element element = session.findElement(uiId, nodeId);
                Optional c = element.getComponent();
                if (c.isPresent()) {
                    if ("showComponentCreateLocation".equals(command)) {
                        this.ideIntegration.showComponentCreateInIde((Component)c.get());
                    } else {
                        this.ideIntegration.showComponentAttachInIde((Component)c.get());
                    }
                } else {
                    DebugWindowConnection.getLogger().error("Only component locations are tracked. The given node id refers to an element and not a component");
                }
            });
        } else if (this.themeEditorMessageHandler.canHandle(command, data)) {
            BaseResponse resultData = this.themeEditorMessageHandler.handleDebugMessageData(command, data);
            this.send(resource, "themeEditorResponse", resultData);
        } else {
            DevToolsMessageHandler plugin;
            boolean handled = false;
            Iterator<DevToolsMessageHandler> iterator = this.plugins.iterator();
            while (iterator.hasNext() && !(handled = (plugin = iterator.next()).handleMessage(command, data, this.getDevToolsInterface(resource)))) {
            }
            if (!handled) {
                DebugWindowConnection.getLogger().info("Unknown command from the browser: " + command);
            }
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)DebugWindowConnection.class.getName());
    }

    public AtmospherePushConnection.FragmentedMessage getOrCreateFragmentedMessage(AtmosphereResource resource) {
        WeakReference<AtmosphereResource> ref = this.getRef(resource);
        if (ref == null) {
            throw new IllegalStateException("Tried to create a fragmented message for a non-existing resource");
        }
        return this.resources.get(ref);
    }

    private WeakReference<AtmosphereResource> getRef(AtmosphereResource resource) {
        return this.resources.keySet().stream().filter(resourceRef -> resource.equals(resourceRef.get())).findFirst().orElse(null);
    }

    public void clearFragmentedMessage(AtmosphereResource resource) {
        WeakReference<AtmosphereResource> ref = this.getRef(resource);
        if (ref == null) {
            DebugWindowConnection.getLogger().debug("Tried to clear the fragmented message for a non-existing resource: {}", (Object)resource);
            return;
        }
        this.resources.put(ref, new AtmospherePushConnection.FragmentedMessage());
    }

    static {
        IDENTIFIER_CLASSES.put(BrowserLiveReload.Backend.JREBEL, Collections.singletonList("org.zeroturnaround.jrebel.vaadin.JRebelClassEventListener"));
        IDENTIFIER_CLASSES.put(BrowserLiveReload.Backend.HOTSWAP_AGENT, Collections.singletonList("org.hotswap.agent.plugin.vaadin.VaadinIntegration"));
        IDENTIFIER_CLASSES.put(BrowserLiveReload.Backend.SPRING_BOOT_DEVTOOLS, Arrays.asList("com.vaadin.flow.spring.SpringServlet", "org.springframework.boot.devtools.livereload.LiveReloadServer"));
    }

    public static class DevToolsInterfaceImpl
    implements DevToolsInterface {
        private DebugWindowConnection debugWindowConnection;
        private AtmosphereResource resource;

        private DevToolsInterfaceImpl(DebugWindowConnection debugWindowConnection, AtmosphereResource resource) {
            this.debugWindowConnection = debugWindowConnection;
            this.resource = resource;
        }

        @Override
        public void send(String command, JsonObject data) {
            JsonObject msg = Json.createObject();
            msg.put("command", command);
            if (data != null) {
                msg.put("data", (JsonValue)data);
            }
            this.debugWindowConnection.send(this.resource, msg.toJson());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DevToolsInterfaceImpl that = (DevToolsInterfaceImpl)o;
            return Objects.equals(this.debugWindowConnection, that.debugWindowConnection) && Objects.equals(this.resource, that.resource);
        }

        public int hashCode() {
            return Objects.hash(this.debugWindowConnection, this.resource);
        }
    }
}

