/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.themeeditor;

import com.vaadin.base.devserver.themeeditor.JavaSourceModifier;
import com.vaadin.base.devserver.themeeditor.ThemeModifier;
import com.vaadin.base.devserver.themeeditor.handlers.ComponentMetadataHandler;
import com.vaadin.base.devserver.themeeditor.handlers.HistoryHandler;
import com.vaadin.base.devserver.themeeditor.handlers.LoadPreviewHandler;
import com.vaadin.base.devserver.themeeditor.handlers.LoadRulesHandler;
import com.vaadin.base.devserver.themeeditor.handlers.LocalClassNameHandler;
import com.vaadin.base.devserver.themeeditor.handlers.MarkAsUsedHandler;
import com.vaadin.base.devserver.themeeditor.handlers.OpenCssHandler;
import com.vaadin.base.devserver.themeeditor.handlers.RulesHandler;
import com.vaadin.base.devserver.themeeditor.messages.BaseResponse;
import com.vaadin.base.devserver.themeeditor.messages.ErrorResponse;
import com.vaadin.base.devserver.themeeditor.utils.HasSourceModifier;
import com.vaadin.base.devserver.themeeditor.utils.HasThemeModifier;
import com.vaadin.base.devserver.themeeditor.utils.MessageHandler;
import com.vaadin.base.devserver.themeeditor.utils.ThemeEditorException;
import com.vaadin.base.devserver.themeeditor.utils.ThemeEditorHistory;
import com.vaadin.flow.server.VaadinContext;
import elemental.json.JsonObject;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemeEditorMessageHandler
implements HasSourceModifier,
HasThemeModifier {
    private final JavaSourceModifier sourceModifier;
    private final ThemeModifier themeModifier;
    private final Set<MessageHandler> handlers = new HashSet<MessageHandler>();

    public ThemeEditorMessageHandler(VaadinContext context) {
        this.sourceModifier = new JavaSourceModifier(context);
        this.themeModifier = new ThemeModifier(context);
        this.handlers.add(new ComponentMetadataHandler(this));
        this.handlers.add(new RulesHandler(this));
        this.handlers.add(new LocalClassNameHandler(this, this));
        this.handlers.add(new HistoryHandler());
        this.handlers.add(new LoadRulesHandler(this));
        this.handlers.add(new LoadPreviewHandler(this));
        this.handlers.add(new OpenCssHandler(this));
        this.handlers.add(new MarkAsUsedHandler());
    }

    public boolean isEnabled() {
        return this.getThemeModifier().isEnabled();
    }

    public String getState() {
        return this.getThemeModifier().getState().name().toLowerCase();
    }

    @Override
    public JavaSourceModifier getSourceModifier() {
        return this.sourceModifier;
    }

    @Override
    public ThemeModifier getThemeModifier() {
        return this.themeModifier;
    }

    public boolean canHandle(String command, JsonObject data) {
        return command != null && data != null && data.hasKey("requestId") && this.getHandler(command).isPresent();
    }

    public BaseResponse handleDebugMessageData(String command, JsonObject data) {
        assert (this.canHandle(command, data));
        String requestId = data.getString("requestId");
        Integer uiId = (int)data.getNumber("uiId");
        ThemeEditorHistory history = ThemeEditorHistory.forUi(uiId);
        try {
            MessageHandler.ExecuteAndUndo executeAndUndo = this.getHandler(command).get().handle(data);
            executeAndUndo.undoCommand().ifPresent(undo -> history.put(requestId, executeAndUndo));
            BaseResponse response = executeAndUndo.executeCommand().execute();
            response.setRequestId(requestId);
            return response;
        }
        catch (ThemeEditorException ex) {
            ThemeEditorMessageHandler.getLogger().error(ex.getMessage(), (Throwable)ex);
            return new ErrorResponse(requestId, ex.getMessage());
        }
    }

    private Optional<MessageHandler> getHandler(String command) {
        return this.handlers.stream().filter(h -> h.getCommandName().equals(command)).findFirst();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)ThemeEditorMessageHandler.class.getName());
    }
}

