/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxws;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.api.ApiRegistry;
import com.webcohesion.enunciate.module.ApiFeatureProviderModule;
import com.webcohesion.enunciate.module.ApiRegistryProviderModule;
import com.webcohesion.enunciate.module.BasicProviderModule;
import com.webcohesion.enunciate.module.DependencySpec;
import com.webcohesion.enunciate.module.EnunciateModule;
import com.webcohesion.enunciate.module.TypeDetectingModule;
import com.webcohesion.enunciate.module.WebInfAwareModule;
import com.webcohesion.enunciate.modules.jaxb.JaxbModule;
import com.webcohesion.enunciate.modules.jaxb.model.ImplicitChildElement;
import com.webcohesion.enunciate.modules.jaxws.EnunciateJaxwsContext;
import com.webcohesion.enunciate.modules.jaxws.JaxwsApiRegistry;
import com.webcohesion.enunciate.modules.jaxws.model.EndpointImplementation;
import com.webcohesion.enunciate.modules.jaxws.model.EndpointInterface;
import com.webcohesion.enunciate.modules.jaxws.model.WebFault;
import com.webcohesion.enunciate.modules.jaxws.model.WebMethod;
import com.webcohesion.enunciate.modules.jaxws.model.WebParam;
import com.webcohesion.enunciate.modules.jaxws.model.WebResult;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jws.WebService;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.reflections.adapters.MetadataAdapter;

public class JaxwsModule
extends BasicProviderModule
implements TypeDetectingModule,
ApiRegistryProviderModule,
ApiFeatureProviderModule,
WebInfAwareModule {
    private JaxbModule jaxbModule;
    private ApiRegistryProviderModule.DataTypeDetectionStrategy defaultDataTypeDetectionStrategy;
    private EnunciateJaxwsContext jaxwsContext;
    private File webInfDir;

    public String getName() {
        return "jaxws";
    }

    public List<DependencySpec> getDependencySpecifications() {
        return Collections.singletonList(new JaxbDependencySpec());
    }

    public EnunciateJaxwsContext getJaxwsContext() {
        return this.jaxwsContext;
    }

    public ApiRegistry getApiRegistry() {
        return new JaxwsApiRegistry(this.jaxwsContext);
    }

    public ApiRegistryProviderModule.DataTypeDetectionStrategy getDataTypeDetectionStrategy() {
        String dataTypeDetection = this.config.getString("[@datatype-detection]", null);
        if (dataTypeDetection != null) {
            try {
                return ApiRegistryProviderModule.DataTypeDetectionStrategy.valueOf((String)dataTypeDetection);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.defaultDataTypeDetectionStrategy != null) {
            return this.defaultDataTypeDetectionStrategy;
        }
        if (this.enunciate.getIncludePatterns().isEmpty()) {
            return ApiRegistryProviderModule.DataTypeDetectionStrategy.local;
        }
        return ApiRegistryProviderModule.DataTypeDetectionStrategy.aggressive;
    }

    public void setDefaultDataTypeDetectionStrategy(ApiRegistryProviderModule.DataTypeDetectionStrategy strategy) {
        this.defaultDataTypeDetectionStrategy = strategy;
    }

    private boolean isUseSourceParameterNames() {
        return this.config.getBoolean("[@useSourceParameterNames]", false);
    }

    private boolean isAggressiveWebMethodExcludePolicy() {
        return this.config.getBoolean("[@aggressiveWebMethodExcludePolicy]", false);
    }

    public void setWebInfDir(File webInfDir) {
        this.webInfDir = webInfDir;
    }

    public File getSunJaxwsXmlFile() {
        File sunJaxwsXmlFile = null;
        String configuredSunJaxwsXmlFile = this.config.getString("[@sun-jaxws-xml-file]", null);
        if (configuredSunJaxwsXmlFile != null) {
            sunJaxwsXmlFile = this.resolveFile(configuredSunJaxwsXmlFile);
        } else if (this.webInfDir != null) {
            sunJaxwsXmlFile = new File(this.webInfDir, "sun-jaxws.xml");
        }
        if (sunJaxwsXmlFile != null && sunJaxwsXmlFile.exists()) {
            return sunJaxwsXmlFile;
        }
        return null;
    }

    public void call(EnunciateContext context) {
        ApiRegistryProviderModule.DataTypeDetectionStrategy detectionStrategy;
        this.jaxwsContext = new EnunciateJaxwsContext(this.jaxbModule.getJaxbContext(), this.isUseSourceParameterNames());
        boolean aggressiveWebMethodExcludePolicy = this.isAggressiveWebMethodExcludePolicy();
        HashMap<String, String> eiPaths = new HashMap<String, String>();
        File sunJaxwsXmlFile = this.getSunJaxwsXmlFile();
        if (sunJaxwsXmlFile != null) {
            XMLConfiguration config;
            try {
                config = new XMLConfiguration(sunJaxwsXmlFile);
            }
            catch (ConfigurationException e) {
                throw new EnunciateException((Throwable)e);
            }
            List endpoints = config.configurationsAt("endpoint");
            for (HierarchicalConfiguration endpoint : endpoints) {
                String impl = endpoint.getString("[@implementation]", null);
                String urlPattern = endpoint.getString("[@url-pattern]", null);
                if (impl == null || urlPattern == null) continue;
                eiPaths.put(impl, urlPattern);
            }
        }
        if ((detectionStrategy = this.getDataTypeDetectionStrategy()) != ApiRegistryProviderModule.DataTypeDetectionStrategy.passive) {
            Set elements = detectionStrategy == ApiRegistryProviderModule.DataTypeDetectionStrategy.local ? context.getLocalApiElements() : context.getApiElements();
            for (Element declaration : elements) {
                if (!(declaration instanceof TypeElement)) continue;
                TypeElement element = (TypeElement)declaration;
                XmlRegistry registryMetadata = declaration.getAnnotation(XmlRegistry.class);
                if (registryMetadata != null) {
                    this.jaxbModule.addPotentialJaxbElement((Element)element, new LinkedList());
                }
                if (!this.isEndpointInterface(element)) continue;
                EndpointInterface ei = new EndpointInterface(element, elements, aggressiveWebMethodExcludePolicy, this.jaxwsContext);
                for (EndpointImplementation implementation : ei.getEndpointImplementations()) {
                    String urlPattern = (String)eiPaths.get(implementation.getQualifiedName().toString());
                    if (urlPattern == null) continue;
                    if (!urlPattern.startsWith("/")) {
                        urlPattern = "/" + urlPattern;
                    }
                    if (urlPattern.endsWith("/*")) {
                        urlPattern = urlPattern.substring(0, urlPattern.length() - 2) + ei.getServiceName();
                    }
                    implementation.setPath(urlPattern);
                }
                this.jaxwsContext.add(ei);
                this.addReferencedDataTypeDefinitions(ei);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addReferencedDataTypeDefinitions(EndpointInterface ei) {
        LinkedList<Element> contextStack = new LinkedList<Element>();
        contextStack.push((Element)((Object)ei));
        try {
            for (WebMethod webMethod : ei.getWebMethods()) {
                this.addReferencedTypeDefinitions(webMethod, contextStack);
            }
        }
        finally {
            contextStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addReferencedTypeDefinitions(WebMethod webMethod, LinkedList<Element> contextStack) {
        contextStack.push((Element)((Object)webMethod));
        try {
            WebResult result = webMethod.getWebResult();
            this.jaxbModule.getJaxbContext().addReferencedTypeDefinitions((TypeMirror)(result.isAdapted() ? result.getAdapterType() : result.getType()), contextStack);
            for (WebParam webParam : webMethod.getWebParameters()) {
                this.jaxbModule.getJaxbContext().addReferencedTypeDefinitions((TypeMirror)(webParam.isAdapted() ? webParam.getAdapterType() : webParam.getType()), contextStack);
            }
            for (WebFault webFault : webMethod.getWebFaults()) {
                this.addReferencedTypeDefinitions(webFault, contextStack);
            }
        }
        finally {
            contextStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addReferencedTypeDefinitions(WebFault webFault, LinkedList<Element> contextStack) {
        contextStack.push((Element)((Object)webFault));
        try {
            if (webFault.isImplicitSchemaElement()) {
                for (ImplicitChildElement childElement : webFault.getChildElements()) {
                    WebFault.FaultBeanChildElement fbce = (WebFault.FaultBeanChildElement)childElement;
                    this.jaxbModule.getJaxbContext().addReferencedTypeDefinitions((TypeMirror)(fbce.isAdapted() ? fbce.getAdapterType() : fbce.getType()), contextStack);
                }
            } else {
                DeclaredType faultBeanType = webFault.getExplicitFaultBeanType();
                if (faultBeanType != null) {
                    this.jaxbModule.getJaxbContext().addReferencedTypeDefinitions((TypeMirror)faultBeanType, contextStack);
                }
            }
        }
        finally {
            contextStack.pop();
        }
    }

    public boolean internal(Object type, MetadataAdapter metadata) {
        String classname = metadata.getClassName(type);
        return classname.startsWith("com.sun.xml.ws");
    }

    public boolean typeDetected(Object type, MetadataAdapter metadata) {
        List classAnnotations = metadata.getClassAnnotationNames(type);
        if (classAnnotations != null) {
            for (String classAnnotation : classAnnotations) {
                if (!WebService.class.getName().equals(classAnnotation)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEndpointInterface(TypeElement declaration) {
        WebService ws = declaration.getAnnotation(WebService.class);
        return declaration.getAnnotation(XmlTransient.class) == null && ws != null && (declaration.getKind() == ElementKind.INTERFACE || ws.endpointInterface() == null || "".equals(ws.endpointInterface()));
    }

    public class JaxbDependencySpec
    implements DependencySpec {
        public boolean accept(EnunciateModule module) {
            if (module instanceof JaxbModule) {
                JaxwsModule.this.jaxbModule = (JaxbModule)module;
                JaxwsModule.this.jaxbModule.setDefaultDataTypeDetectionStrategy(ApiRegistryProviderModule.DataTypeDetectionStrategy.passive);
                return true;
            }
            return false;
        }

        public boolean isFulfilled() {
            return JaxwsModule.this.jaxbModule != null;
        }

        public String toString() {
            return "jaxb";
        }
    }
}

