/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxws.api.impl;

import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.services.Operation;
import com.webcohesion.enunciate.api.services.Service;
import com.webcohesion.enunciate.api.services.ServiceApi;
import com.webcohesion.enunciate.api.services.ServiceGroup;
import com.webcohesion.enunciate.modules.jaxws.EnunciateJaxwsContext;
import com.webcohesion.enunciate.modules.jaxws.WsdlInfo;
import com.webcohesion.enunciate.modules.jaxws.api.impl.OperationImpl;
import com.webcohesion.enunciate.modules.jaxws.api.impl.ServiceGroupImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JaxwsServiceApi
implements ServiceApi {
    private final EnunciateJaxwsContext context;
    private ApiRegistrationContext registrationContext;

    public JaxwsServiceApi(EnunciateJaxwsContext context, ApiRegistrationContext registrationContext) {
        this.context = context;
        this.registrationContext = registrationContext;
    }

    public String getContextPath() {
        return this.context.getContextPath();
    }

    public List<ServiceGroup> getServiceGroups() {
        Map<String, WsdlInfo> wsdls = this.context.getWsdls();
        ArrayList<ServiceGroup> serviceGroups = new ArrayList<ServiceGroup>();
        for (WsdlInfo wsdlInfo : wsdls.values()) {
            serviceGroups.add(new ServiceGroupImpl(wsdlInfo, this.registrationContext));
        }
        return serviceGroups;
    }

    public Operation findOperationFor(String classname, String method) {
        if (method.isEmpty() || classname.isEmpty()) {
            return null;
        }
        for (ServiceGroup serviceGroup : this.getServiceGroups()) {
            for (Service service : serviceGroup.getServices()) {
                for (Operation operation : service.getOperations()) {
                    if (!(operation instanceof OperationImpl) || !method.startsWith(((OperationImpl)operation).getWebMethod().getSimpleName().toString()) || !((OperationImpl)operation).getWebMethod().getDeclaringEndpointInterface().getQualifiedName().contentEquals(classname)) continue;
                    return operation;
                }
            }
        }
        return null;
    }

    public Service findServiceFor(String classname) {
        if (classname.isEmpty()) {
            return null;
        }
        for (ServiceGroup serviceGroup : this.getServiceGroups()) {
            for (Service service : serviceGroup.getServices()) {
                for (Operation operation : service.getOperations()) {
                    if (!(operation instanceof OperationImpl) || !((OperationImpl)operation).getWebMethod().getDeclaringEndpointInterface().getQualifiedName().contentEquals(classname)) continue;
                    return service;
                }
            }
        }
        return null;
    }
}

