/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxws.api.impl;

import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.InterfaceDescriptionFile;
import com.webcohesion.enunciate.api.services.Service;
import com.webcohesion.enunciate.api.services.ServiceGroup;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.modules.jaxws.WsdlInfo;
import com.webcohesion.enunciate.modules.jaxws.api.impl.ServiceImpl;
import com.webcohesion.enunciate.modules.jaxws.model.EndpointInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ServiceGroupImpl
implements ServiceGroup {
    private final WsdlInfo wsdlInfo;
    private final ApiRegistrationContext registrationContext;

    public ServiceGroupImpl(WsdlInfo wsdlInfo, ApiRegistrationContext registrationContext) {
        this.wsdlInfo = wsdlInfo;
        this.registrationContext = registrationContext;
    }

    public String getNamespace() {
        return this.wsdlInfo.getTargetNamespace();
    }

    public InterfaceDescriptionFile getWsdlFile() {
        return this.wsdlInfo.getWsdlFile();
    }

    public List<? extends Service> getServices() {
        ArrayList<ServiceImpl> services = new ArrayList<ServiceImpl>();
        FacetFilter facetFilter = this.wsdlInfo.getContext().getContext().getConfiguration().getFacetFilter();
        for (EndpointInterface endpointInterface : this.wsdlInfo.getEndpointInterfaces()) {
            if (!facetFilter.accept((HasFacets)endpointInterface)) continue;
            services.add(new ServiceImpl(endpointInterface, "", this.registrationContext));
        }
        Collections.sort(services, new Comparator<Service>(){

            @Override
            public int compare(Service o1, Service o2) {
                return o1.getLabel().compareTo(o2.getLabel());
            }
        });
        return services;
    }
}

