/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxws.api.impl;

import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.Styles;
import com.webcohesion.enunciate.api.services.Operation;
import com.webcohesion.enunciate.api.services.Service;
import com.webcohesion.enunciate.api.services.ServiceGroup;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.javac.javadoc.JavaDocTagHandler;
import com.webcohesion.enunciate.metadata.Label;
import com.webcohesion.enunciate.modules.jaxws.api.impl.OperationImpl;
import com.webcohesion.enunciate.modules.jaxws.api.impl.ServiceGroupImpl;
import com.webcohesion.enunciate.modules.jaxws.model.EndpointInterface;
import com.webcohesion.enunciate.modules.jaxws.model.WebMethod;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

public class ServiceImpl
implements Service {
    private final EndpointInterface ei;
    private final String contextPath;
    private ApiRegistrationContext registrationContext;

    public ServiceImpl(EndpointInterface ei, String contextPath, ApiRegistrationContext registrationContext) {
        this.ei = ei;
        this.contextPath = contextPath;
        this.registrationContext = registrationContext;
    }

    public String getLabel() {
        String tag;
        Label label = (Label)this.ei.getAnnotation(Label.class);
        if (label != null) {
            return label.value();
        }
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.ei.getJavaDoc().get((Object)"label");
        if (tags != null && tags.size() > 0 && !(tag = ((String)tags.get(0)).trim()).isEmpty()) {
            return tag;
        }
        String serviceName = this.ei.getServiceName();
        if (serviceName.equals(this.ei.getSimpleName() + "Service")) {
            serviceName = this.ei.getSimpleName().toString();
        }
        return serviceName;
    }

    public String getPath() {
        return this.contextPath + this.ei.getPath();
    }

    public String getNamespace() {
        return this.ei.getTargetNamespace();
    }

    public ServiceGroup getGroup() {
        return new ServiceGroupImpl(this.ei.getContext().getWsdls().get(this.ei.getTargetNamespace()), this.registrationContext);
    }

    public String getSlug() {
        return "service_" + (String)this.ei.getContext().getJaxbContext().getNamespacePrefixes().get(this.ei.getTargetNamespace()) + "_" + this.ei.getServiceName();
    }

    public String getDescription() {
        return this.ei.getJavaDoc(this.registrationContext.getTagHandler()).toString();
    }

    public String getDeprecated() {
        return ElementUtils.findDeprecationMessage((DecoratedElement)this.ei, (JavaDocTagHandler)this.registrationContext.getTagHandler());
    }

    public String getSince() {
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.ei.getJavaDoc(this.registrationContext.getTagHandler()).get((Object)"since");
        if (tags == null) {
            tags = (JavaDoc.JavaDocTagList)((DecoratedElement)this.ei.getPackage()).getJavaDoc(this.registrationContext.getTagHandler()).get((Object)"since");
        }
        return tags == null ? null : tags.toString();
    }

    public List<String> getSeeAlso() {
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.ei.getJavaDoc(this.registrationContext.getTagHandler()).get((Object)"see");
        if (tags == null) {
            tags = (JavaDoc.JavaDocTagList)((DecoratedElement)this.ei.getPackage()).getJavaDoc(this.registrationContext.getTagHandler()).get((Object)"see");
        }
        return tags;
    }

    public String getVersion() {
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.ei.getJavaDoc(this.registrationContext.getTagHandler()).get((Object)"version");
        return tags == null ? null : tags.toString();
    }

    public List<? extends Operation> getOperations() {
        ArrayList<OperationImpl> operations = new ArrayList<OperationImpl>();
        FacetFilter facetFilter = this.ei.getContext().getContext().getConfiguration().getFacetFilter();
        for (WebMethod webMethod : this.ei.getWebMethods()) {
            if (!facetFilter.accept((HasFacets)webMethod)) continue;
            operations.add(new OperationImpl(webMethod, this, this.registrationContext));
        }
        return operations;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)this.ei.getAnnotation(annotationType);
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return this.ei.getAnnotations();
    }

    public Set<Facet> getFacets() {
        return this.ei.getFacets();
    }

    public JavaDoc getJavaDoc() {
        return this.ei.getJavaDoc(this.registrationContext.getTagHandler());
    }

    public Set<String> getStyles() {
        return Styles.gatherStyles((Element)((Object)this.ei), (Map)this.ei.getContext().getContext().getConfiguration().getAnnotationStyles());
    }

    public Element getJavaElement() {
        return this.ei;
    }
}

