/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxws.model;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedTypeElement;
import com.webcohesion.enunciate.javac.decorations.element.PropertyElement;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.metadata.ClientName;
import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.model.ElementDeclaration;
import com.webcohesion.enunciate.modules.jaxb.model.ImplicitChildElement;
import com.webcohesion.enunciate.modules.jaxb.model.ImplicitRootElement;
import com.webcohesion.enunciate.modules.jaxb.model.adapters.Adaptable;
import com.webcohesion.enunciate.modules.jaxb.model.adapters.AdapterType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlTypeFactory;
import com.webcohesion.enunciate.modules.jaxb.model.util.JAXBUtil;
import com.webcohesion.enunciate.modules.jaxb.model.util.MapType;
import com.webcohesion.enunciate.modules.jaxws.EnunciateJaxwsContext;
import com.webcohesion.enunciate.modules.jaxws.model.WebMessage;
import com.webcohesion.enunciate.modules.jaxws.model.WebMessagePart;
import com.webcohesion.enunciate.modules.jaxws.model.WebMethod;
import com.webcohesion.enunciate.util.HasClientConvertibleType;
import com.webcohesion.enunciate.util.IgnoreUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.namespace.QName;

public class WebFault
extends DecoratedTypeElement
implements WebMessage,
WebMessagePart,
ImplicitRootElement,
HasFacets {
    private final javax.xml.ws.WebFault annotation;
    private final DeclaredType explicitFaultBeanType;
    private final Set<Facet> facets = new TreeSet<Facet>();
    private final EnunciateJaxwsContext context;
    private final DecoratedTypeMirror reference;

    public WebFault(TypeElement delegate, DecoratedTypeMirror reference, EnunciateJaxwsContext context) {
        super(delegate, context.getContext().getProcessingEnvironment());
        this.context = context;
        this.annotation = (javax.xml.ws.WebFault)this.getAnnotation(javax.xml.ws.WebFault.class);
        this.reference = reference;
        DeclaredType explicitFaultBeanType = null;
        List properties = this.getProperties();
        PropertyElement faultInfoProperty = null;
        for (PropertyElement propertyDeclaration : properties) {
            if (!"faultInfo".equals(propertyDeclaration.getPropertyName())) continue;
            faultInfoProperty = propertyDeclaration;
            break;
        }
        if (faultInfoProperty != null && faultInfoProperty.getPropertyType() instanceof DeclaredType) {
            DeclaredType faultInfoType = (DeclaredType)faultInfoProperty.getPropertyType();
            if (faultInfoType.asElement() == null) {
                throw new EnunciateException(this.getQualifiedName() + ": class not found: " + faultInfoType + ".");
            }
            boolean messageConstructorFound = false;
            boolean messageAndThrowableConstructorFound = false;
            List constructors = this.getConstructors();
            for (ExecutableElement constructor : constructors) {
                VariableElement[] parameters;
                if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC) || (parameters = constructor.getParameters().toArray(new VariableElement[constructor.getParameters().size()])).length < 2) continue;
                DecoratedTypeMirror param0Type = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)parameters[0].asType(), (DecoratedProcessingEnvironment)this.env);
                DecoratedTypeMirror param1Type = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)parameters[1].asType(), (DecoratedProcessingEnvironment)this.env);
                if (parameters.length == 2) {
                    messageConstructorFound |= param0Type.isInstanceOf(String.class.getName()) && param1Type.isInstanceOf((TypeMirror)faultInfoType);
                    continue;
                }
                if (parameters.length != 3) continue;
                DecoratedTypeMirror param2Type = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)parameters[2].asType(), (DecoratedProcessingEnvironment)this.env);
                messageAndThrowableConstructorFound |= param0Type.isInstanceOf(String.class.getName()) && param1Type.isInstanceOf((TypeMirror)faultInfoType) && param2Type.isInstanceOf(Throwable.class);
            }
            if (messageConstructorFound && messageAndThrowableConstructorFound) {
                explicitFaultBeanType = faultInfoType;
            }
        }
        if (faultInfoProperty != null && explicitFaultBeanType == null) {
            throw new EnunciateException("The 'getFaultInfo' method is only allowed on a web fault if you're declaring an explicit fault bean, and you don't have the right constructor signatures set up in order for '" + faultInfoProperty.getPropertyType() + "' to be an explicit fault bean.");
        }
        this.explicitFaultBeanType = explicitFaultBeanType;
        this.facets.addAll(Facet.gatherFacets((Element)delegate, (EnunciateContext)context.getContext()));
    }

    @Override
    public String getMessageName() {
        return this.getSimpleName().toString();
    }

    @Override
    public String getMessageDocs() {
        return this.getElementDocs();
    }

    public Set<Facet> getFacets() {
        return this.facets;
    }

    public String getElementName() {
        String name = null;
        if (this.isImplicitSchemaElement()) {
            name = this.getParticleName();
        }
        return name;
    }

    private String getParticleName() {
        String name = this.getSimpleName().toString();
        if (this.annotation != null && this.annotation.name() != null && !"".equals(this.annotation.name())) {
            name = this.annotation.name();
        }
        return name;
    }

    public String getClientSimpleName() {
        String clientSimpleName = this.getSimpleName().toString();
        ClientName clientName = (ClientName)this.getAnnotation(ClientName.class);
        if (clientName != null) {
            clientSimpleName = clientName.value();
        }
        return clientSimpleName;
    }

    public String getElementDocs() {
        String docs = this.getJavaDoc().toString();
        if (docs.trim().length() == 0) {
            docs = null;
        }
        return docs;
    }

    @Override
    public String getPartName() {
        return this.getSimpleName().toString();
    }

    @Override
    public String getPartDocs() {
        return this.getConditions();
    }

    public String getConditions() {
        return this.reference.getDocValue();
    }

    public String getImplicitFaultBeanQualifiedName() {
        String faultBean = null;
        if (this.isImplicitSchemaElement()) {
            faultBean = this.getPackage().getQualifiedName() + ".jaxws." + this.getSimpleName() + "Bean";
            if (this.annotation != null && this.annotation.faultBean() != null && !"".equals(this.annotation.faultBean())) {
                faultBean = this.annotation.faultBean();
            }
        }
        return faultBean;
    }

    public DeclaredType getExplicitFaultBeanType() {
        return this.explicitFaultBeanType;
    }

    public ElementDeclaration findExplicitFaultBean() {
        if (this.explicitFaultBeanType == null || this.explicitFaultBeanType.asElement() == null) {
            return null;
        }
        return this.context.getJaxbContext().findElementDeclaration(this.explicitFaultBeanType.asElement());
    }

    @Override
    public WebMessagePart.ParticleType getParticleType() {
        return WebMessagePart.ParticleType.ELEMENT;
    }

    @Override
    public QName getParticleQName() {
        ElementDeclaration faultBean = this.findExplicitFaultBean();
        if (faultBean != null) {
            return new QName(faultBean.getNamespace(), faultBean.getName());
        }
        return new QName(this.getTargetNamespace(), this.getParticleName());
    }

    public String getTargetNamespace() {
        String targetNamespace = null;
        if (this.isImplicitSchemaElement()) {
            if (this.annotation != null) {
                targetNamespace = this.annotation.targetNamespace();
            }
            if (targetNamespace == null || "".equals(targetNamespace)) {
                targetNamespace = this.calculateNamespaceURI();
            }
        }
        return targetNamespace;
    }

    protected String calculateNamespaceURI() {
        PackageElement pkg = this.getPackage();
        if (pkg == null || "".equals(pkg.getQualifiedName().toString())) {
            throw new EnunciateException(this.getQualifiedName() + ": a web fault in no package must specify a target namespace.");
        }
        String[] tokens = pkg.getQualifiedName().toString().split("\\.");
        String uri = "http://";
        for (int i = tokens.length - 1; i >= 0; --i) {
            uri = uri + tokens[i];
            if (i == 0) continue;
            uri = uri + ".";
        }
        uri = uri + "/";
        return uri;
    }

    public QName getTypeQName() {
        return null;
    }

    @Override
    public boolean isImplicitSchemaElement() {
        return this.explicitFaultBeanType == null;
    }

    public Collection<ImplicitChildElement> getChildElements() {
        if (!this.isImplicitSchemaElement()) {
            return Collections.emptyList();
        }
        TreeSet<ImplicitChildElement> childElements = new TreeSet<ImplicitChildElement>(new Comparator<ImplicitChildElement>(){

            @Override
            public int compare(ImplicitChildElement o1, ImplicitChildElement o2) {
                return o1.getElementName().compareTo(o2.getElementName());
            }
        });
        for (PropertyElement property : this.getAllFaultProperties(this)) {
            String propertyName = property.getPropertyName();
            if ("cause".equals(propertyName) || "localizedMessage".equals(propertyName) || "stackTrace".equals(propertyName) || "suppressed".equals(propertyName)) continue;
            childElements.add(new FaultBeanChildElement(property, this, this.context.getJaxbContext()));
        }
        return childElements;
    }

    protected Collection<PropertyElement> getAllFaultProperties(DecoratedTypeElement declaration) {
        ArrayList<PropertyElement> properties = new ArrayList<PropertyElement>();
        TreeSet<String> excludedProperties = new TreeSet<String>();
        while (declaration != null && !Object.class.getName().equals(declaration.getQualifiedName().toString())) {
            for (PropertyElement property : declaration.getProperties()) {
                if (property.getGetter() != null && property.getAnnotation(XmlTransient.class) == null && !IgnoreUtils.isIgnored((Element)property) && !excludedProperties.contains(property.getPropertyName())) {
                    properties.add(property);
                    continue;
                }
                excludedProperties.add(property.getPropertyName());
            }
            declaration = (DecoratedTypeElement)((DeclaredType)declaration.getSuperclass()).asElement();
        }
        return properties;
    }

    @Override
    public Collection<WebMessagePart> getParts() {
        return new ArrayList<WebMessagePart>(Arrays.asList(this));
    }

    @Override
    public boolean isInput() {
        return false;
    }

    @Override
    public boolean isOutput() {
        return false;
    }

    @Override
    public boolean isHeader() {
        return false;
    }

    @Override
    public boolean isFault() {
        return true;
    }

    @Override
    public WebMethod getWebMethod() {
        throw new UnsupportedOperationException("Web faults aren't associated with a specific web method.");
    }

    public EnunciateJaxwsContext getContext() {
        return this.context;
    }

    public static class FaultBeanChildElement
    implements Adaptable,
    ImplicitChildElement,
    HasClientConvertibleType {
        private final EnunciateJaxbContext context;
        private final PropertyElement property;
        private final int minOccurs;
        private final String maxOccurs;
        private final AdapterType adaperType;
        private final WebFault webFault;

        private FaultBeanChildElement(PropertyElement property, WebFault webFault, EnunciateJaxbContext context) {
            TypeMirror componentType;
            boolean unbounded;
            this.context = context;
            DecoratedTypeMirror propertyType = (DecoratedTypeMirror)property.getPropertyType();
            this.adaperType = JAXBUtil.findAdapterType((Element)property.getGetter(), (EnunciateJaxbContext)context);
            int minOccurs = propertyType.isPrimitive() ? 1 : 0;
            boolean bl = unbounded = propertyType.isCollection() || propertyType.isArray();
            if (propertyType.isArray() && (componentType = ((ArrayType)propertyType).getComponentType()).getKind() == TypeKind.BYTE) {
                unbounded = false;
            }
            String maxOccurs = unbounded ? "unbounded" : "1";
            this.property = property;
            this.minOccurs = minOccurs;
            this.maxOccurs = maxOccurs;
            this.webFault = webFault;
        }

        public PropertyElement getProperty() {
            return this.property;
        }

        public String getElementName() {
            return this.property.getPropertyName();
        }

        public String getTargetNamespace() {
            return this.webFault.getTargetNamespace();
        }

        public String getElementDocs() {
            String docs = this.property.getJavaDoc().toString();
            if (docs.trim().length() == 0) {
                docs = null;
            }
            return docs;
        }

        public XmlType getXmlType() {
            XmlType xmlType = XmlTypeFactory.findSpecifiedType((Adaptable)this, (EnunciateJaxbContext)this.context);
            if (xmlType == null) {
                xmlType = XmlTypeFactory.getXmlType((TypeMirror)this.getType(), (EnunciateJaxbContext)this.context);
            }
            return xmlType;
        }

        public String getMimeType() {
            XmlMimeType mimeType = (XmlMimeType)this.property.getAnnotation(XmlMimeType.class);
            return mimeType == null ? null : mimeType.value();
        }

        public boolean isSwaRef() {
            return this.property.getAnnotation(XmlAttachmentRef.class) != null;
        }

        public QName getTypeQName() {
            return this.getXmlType().getQname();
        }

        public int getMinOccurs() {
            return this.minOccurs;
        }

        public String getMaxOccurs() {
            return this.maxOccurs;
        }

        public TypeMirror getType() {
            TypeMirror propertyType = this.property.getPropertyType();
            MapType mapType = MapType.findMapType((TypeMirror)propertyType, (EnunciateJaxbContext)this.context);
            if (mapType != null) {
                propertyType = mapType;
            }
            return propertyType;
        }

        public boolean isAdapted() {
            return this.adaperType != null;
        }

        public AdapterType getAdapterType() {
            return this.adaperType;
        }

        public TypeMirror getClientConvertibleType() {
            return this.getType();
        }
    }
}

