/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxws.model;

import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedVariableElement;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.metadata.ClientName;
import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.model.ImplicitChildElement;
import com.webcohesion.enunciate.modules.jaxb.model.adapters.Adaptable;
import com.webcohesion.enunciate.modules.jaxb.model.adapters.AdapterType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlTypeFactory;
import com.webcohesion.enunciate.modules.jaxb.model.util.MapType;
import com.webcohesion.enunciate.modules.jaxws.EnunciateJaxwsContext;
import com.webcohesion.enunciate.modules.jaxws.model.WebMessage;
import com.webcohesion.enunciate.modules.jaxws.model.WebMessagePart;
import com.webcohesion.enunciate.modules.jaxws.model.WebMethod;
import com.webcohesion.enunciate.modules.jaxws.model.util.JAXWSUtil;
import com.webcohesion.enunciate.util.HasClientConvertibleType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.jws.WebParam;
import javax.jws.soap.SOAPBinding;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;

public class WebParam
extends DecoratedVariableElement
implements Adaptable,
WebMessage,
WebMessagePart,
ImplicitChildElement,
HasClientConvertibleType {
    private final javax.jws.WebParam annotation;
    private final WebMethod method;
    private final AdapterType adapterType;
    private final boolean useSourceParameterNames;
    private final int parameterIndex;
    private final EnunciateJaxwsContext context;

    protected WebParam(VariableElement delegate, WebMethod method, int parameterIndex, EnunciateJaxwsContext context) {
        super(delegate, context.getContext().getProcessingEnvironment());
        this.context = context;
        this.method = method;
        this.parameterIndex = parameterIndex;
        if (this.method == null) {
            throw new IllegalArgumentException("A web method must be provided.");
        }
        this.annotation = delegate.getAnnotation(javax.jws.WebParam.class);
        this.adapterType = JAXWSUtil.findAdapterType(this, context.getJaxbContext());
        this.useSourceParameterNames = context.isUseSourceParameterNames();
    }

    public String getBaseParamName() {
        return this.useSourceParameterNames ? this.getSimpleName().toString() : "arg" + this.parameterIndex;
    }

    @Override
    public WebMethod getWebMethod() {
        return this.method;
    }

    public String getElementName() {
        String name;
        String string = name = this.isHeader() ? "" : this.getBaseParamName();
        if (this.annotation != null && this.annotation.name() != null && !"".equals(this.annotation.name())) {
            name = this.annotation.name();
        } else if (!this.isHeader() && this.isImplicitSchemaElement()) {
            name = this.method.getSimpleName().toString();
        }
        return name;
    }

    public String getTargetNamespace() {
        String namespace;
        String string = namespace = this.isImplicitSchemaElement() ? this.method.getDeclaringEndpointInterface().getTargetNamespace() : "";
        if (this.annotation != null && this.annotation.targetNamespace() != null && !"".equals(this.annotation.targetNamespace())) {
            namespace = this.annotation.targetNamespace();
        }
        return namespace;
    }

    public String getClientSimpleName() {
        String clientSimpleName = this.getSimpleName().toString();
        ClientName clientName = (ClientName)this.getAnnotation(ClientName.class);
        if (clientName != null) {
            clientSimpleName = clientName.value();
        }
        return clientSimpleName;
    }

    public String getElementDocs() {
        return this.getDocComment();
    }

    @Override
    public String getPartName() {
        String partName = this.getBaseParamName();
        if (this.annotation != null && this.annotation.partName() != null && !"".equals(this.annotation.partName())) {
            partName = this.annotation.partName();
        }
        return partName;
    }

    @Override
    public String getMessageName() {
        String messageName = null;
        if (this.isBare()) {
            messageName = this.method.getDeclaringEndpointInterface().getSimpleName() + "." + this.method.getSimpleName();
        } else if (this.isHeader()) {
            messageName = this.method.getDeclaringEndpointInterface().getSimpleName() + "." + this.method.getSimpleName() + "." + this.getBaseParamName();
        }
        return messageName;
    }

    @Override
    public String getMessageDocs() {
        if (this.isBare()) {
            return this.getDocComment();
        }
        return null;
    }

    @Override
    public String getPartDocs() {
        if (this.isBare()) {
            return null;
        }
        return this.getDocComment();
    }

    @Override
    public WebMessagePart.ParticleType getParticleType() {
        return this.method.getSoapBindingStyle() == SOAPBinding.Style.RPC ? (this.isHeader() ? WebMessagePart.ParticleType.ELEMENT : WebMessagePart.ParticleType.TYPE) : WebMessagePart.ParticleType.ELEMENT;
    }

    @Override
    public QName getParticleQName() {
        if (this.method.getSoapBindingStyle() == SOAPBinding.Style.RPC && !this.isHeader()) {
            return this.getTypeQName();
        }
        return new QName(this.getTargetNamespace(), this.getElementName());
    }

    @Override
    public boolean isImplicitSchemaElement() {
        return this.isHeader() || this.method.getSoapBindingStyle() != SOAPBinding.Style.RPC && this.method.getSoapParameterStyle() == SOAPBinding.ParameterStyle.BARE;
    }

    public QName getTypeQName() {
        return this.getXmlType().getQname();
    }

    public TypeMirror getType() {
        TypeMirror type = super.asType();
        MapType mapType = MapType.findMapType((TypeMirror)type, (EnunciateJaxbContext)this.context.getJaxbContext());
        if (mapType != null) {
            type = mapType;
        }
        return type;
    }

    public XmlType getXmlType() {
        XmlType xmlType = XmlTypeFactory.findSpecifiedType((Adaptable)this, (EnunciateJaxbContext)this.context.getJaxbContext());
        if (xmlType == null) {
            TypeMirror type = this.getType();
            if (this.isHolder()) {
                List<? extends TypeMirror> typeArgs = ((DeclaredType)type).getTypeArguments();
                if (typeArgs == null || typeArgs.size() == 0) {
                    throw new EnunciateException("Parameter " + this.getSimpleName() + ": unable to get the type of the holder.");
                }
                type = typeArgs.iterator().next();
            }
            xmlType = XmlTypeFactory.getXmlType((TypeMirror)type, (EnunciateJaxbContext)this.context.getJaxbContext());
        }
        return xmlType;
    }

    public String getMimeType() {
        XmlMimeType mimeType = (XmlMimeType)this.getAnnotation(XmlMimeType.class);
        return mimeType == null ? null : mimeType.value();
    }

    public boolean isSwaRef() {
        return this.getAnnotation(XmlAttachmentRef.class) != null;
    }

    public int getMinOccurs() {
        DecoratedTypeMirror paramType = (DecoratedTypeMirror)this.getType();
        return paramType.isPrimitive() ? 1 : 0;
    }

    public String getMaxOccurs() {
        TypeMirror componentType;
        boolean unbounded;
        DecoratedTypeMirror paramType = (DecoratedTypeMirror)this.getType();
        boolean bl = unbounded = paramType.isCollection() || paramType.isArray();
        if (paramType.isArray() && (componentType = ((ArrayType)paramType).getComponentType()).getKind() == TypeKind.BYTE) {
            unbounded = false;
        }
        return unbounded ? "unbounded" : "1";
    }

    public WebParam.Mode getMode() {
        WebParam.Mode mode = WebParam.Mode.IN;
        if (this.annotation != null && this.annotation.mode() != null) {
            mode = this.annotation.mode();
        }
        return mode;
    }

    @Override
    public boolean isHeader() {
        boolean header = false;
        if (this.annotation != null) {
            header = this.annotation.header();
        }
        return header;
    }

    private boolean isBare() {
        return this.method.getSoapParameterStyle() == SOAPBinding.ParameterStyle.BARE;
    }

    @Override
    public boolean isInput() {
        return this.getMode() == WebParam.Mode.IN || this.getMode() == WebParam.Mode.INOUT && this.isHolder();
    }

    @Override
    public boolean isOutput() {
        return this.getMode() == WebParam.Mode.OUT || this.getMode() == WebParam.Mode.INOUT && this.isHolder();
    }

    public boolean isHolder() {
        Element element;
        TypeMirror type = this.getType();
        if (type instanceof DeclaredType && (element = ((DeclaredType)type).asElement()) instanceof TypeElement) {
            return ((TypeElement)element).getQualifiedName().toString().equals(Holder.class.getName());
        }
        return false;
    }

    @Override
    public boolean isFault() {
        return false;
    }

    @Override
    public Collection<WebMessagePart> getParts() {
        if (!this.isBare() && !this.isHeader()) {
            throw new UnsupportedOperationException("Web param doesn't represent a complex method input/output.");
        }
        return new ArrayList<WebMessagePart>(Arrays.asList(this));
    }

    public boolean isAdapted() {
        return this.adapterType != null;
    }

    public AdapterType getAdapterType() {
        return this.adapterType;
    }

    public TypeMirror getClientConvertibleType() {
        return this.getType();
    }

    public EnunciateJaxwsContext getContext() {
        return this.context;
    }
}

