/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.merchant.hostedcheckout;

import com.onlinepayments.ApiResource;
import com.onlinepayments.CallContext;
import com.onlinepayments.ResponseException;
import com.onlinepayments.domain.CreateHostedCheckoutRequest;
import com.onlinepayments.domain.CreateHostedCheckoutResponse;
import com.onlinepayments.domain.ErrorResponse;
import com.onlinepayments.domain.GetHostedCheckoutResponse;
import com.onlinepayments.merchant.hostedcheckout.HostedCheckoutClientInterface;
import java.util.Map;
import java.util.TreeMap;

public class HostedCheckoutClient
extends ApiResource
implements HostedCheckoutClientInterface {
    public HostedCheckoutClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    @Override
    public CreateHostedCheckoutResponse createHostedCheckout(CreateHostedCheckoutRequest body) {
        return this.createHostedCheckout(body, null);
    }

    @Override
    public CreateHostedCheckoutResponse createHostedCheckout(CreateHostedCheckoutRequest body, CallContext context) {
        String uri = this.instantiateUri("/v2/{merchantId}/hostedcheckouts", null);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, body, CreateHostedCheckoutResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public GetHostedCheckoutResponse getHostedCheckout(String hostedCheckoutId) {
        return this.getHostedCheckout(hostedCheckoutId, null);
    }

    @Override
    public GetHostedCheckoutResponse getHostedCheckout(String hostedCheckoutId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("hostedCheckoutId", hostedCheckoutId);
        String uri = this.instantiateUri("/v2/{merchantId}/hostedcheckouts/{hostedCheckoutId}", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, GetHostedCheckoutResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

