/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.merchant.payouts;

import com.onlinepayments.ApiResource;
import com.onlinepayments.CallContext;
import com.onlinepayments.ResponseException;
import com.onlinepayments.domain.CreatePayoutRequest;
import com.onlinepayments.domain.ErrorResponse;
import com.onlinepayments.domain.PayoutErrorResponse;
import com.onlinepayments.domain.PayoutResponse;
import com.onlinepayments.merchant.payouts.PayoutsClientInterface;
import java.util.Map;
import java.util.TreeMap;

public class PayoutsClient
extends ApiResource
implements PayoutsClientInterface {
    public PayoutsClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    @Override
    public PayoutResponse createPayout(CreatePayoutRequest body) {
        return this.createPayout(body, null);
    }

    @Override
    public PayoutResponse createPayout(CreatePayoutRequest body, CallContext context) {
        String uri = this.instantiateUri("/v2/{merchantId}/payouts", null);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, body, PayoutResponse.class, context);
        }
        catch (ResponseException e) {
            Class<PayoutErrorResponse> errorType = PayoutErrorResponse.class;
            PayoutErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public PayoutResponse getPayout(String payoutId) {
        return this.getPayout(payoutId, null);
    }

    @Override
    public PayoutResponse getPayout(String payoutId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("payoutId", payoutId);
        String uri = this.instantiateUri("/v2/{merchantId}/payouts/{payoutId}", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, PayoutResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

