/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.merchant.services;

import com.onlinepayments.ApiResource;
import com.onlinepayments.CallContext;
import com.onlinepayments.ResponseException;
import com.onlinepayments.domain.CalculateSurchargeRequest;
import com.onlinepayments.domain.CalculateSurchargeResponse;
import com.onlinepayments.domain.CurrencyConversionRequest;
import com.onlinepayments.domain.CurrencyConversionResponse;
import com.onlinepayments.domain.ErrorResponse;
import com.onlinepayments.domain.GetIINDetailsRequest;
import com.onlinepayments.domain.GetIINDetailsResponse;
import com.onlinepayments.domain.GetPrivacyPolicyResponse;
import com.onlinepayments.domain.TestConnection;
import com.onlinepayments.merchant.services.GetPrivacyPolicyParams;
import com.onlinepayments.merchant.services.ServicesClientInterface;
import java.util.Map;

public class ServicesClient
extends ApiResource
implements ServicesClientInterface {
    public ServicesClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    @Override
    public CalculateSurchargeResponse surchargeCalculation(CalculateSurchargeRequest body) {
        return this.surchargeCalculation(body, null);
    }

    @Override
    public CalculateSurchargeResponse surchargeCalculation(CalculateSurchargeRequest body, CallContext context) {
        String uri = this.instantiateUri("/v2/{merchantId}/services/surchargecalculation", null);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, body, CalculateSurchargeResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public CurrencyConversionResponse getDccRateInquiry(CurrencyConversionRequest body) {
        return this.getDccRateInquiry(body, null);
    }

    @Override
    public CurrencyConversionResponse getDccRateInquiry(CurrencyConversionRequest body, CallContext context) {
        String uri = this.instantiateUri("/v2/{merchantId}/services/dccrate", null);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, body, CurrencyConversionResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public GetPrivacyPolicyResponse getPrivacyPolicy(GetPrivacyPolicyParams query) {
        return this.getPrivacyPolicy(query, null);
    }

    @Override
    public GetPrivacyPolicyResponse getPrivacyPolicy(GetPrivacyPolicyParams query, CallContext context) {
        String uri = this.instantiateUri("/v2/{merchantId}/services/privacypolicy", null);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), query, GetPrivacyPolicyResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public TestConnection testConnection() {
        return this.testConnection(null);
    }

    @Override
    public TestConnection testConnection(CallContext context) {
        String uri = this.instantiateUri("/v2/{merchantId}/services/testconnection", null);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, TestConnection.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public GetIINDetailsResponse getIINDetails(GetIINDetailsRequest body) {
        return this.getIINDetails(body, null);
    }

    @Override
    public GetIINDetailsResponse getIINDetails(GetIINDetailsRequest body, CallContext context) {
        String uri = this.instantiateUri("/v2/{merchantId}/services/getIINdetails", null);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, body, GetIINDetailsResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

