/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.themes.markup.html.bootswatch;

import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.core.settings.ITheme;
import de.agilecoders.wicket.themes.markup.html.bootswatch.BootswatchCssReference;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.UrlResourceReference;

public enum BootswatchTheme implements ITheme
{
    Cerulean,
    Cosmo,
    Cyborg,
    Darkly,
    Flatly,
    Journal,
    Litera,
    Lumen,
    Lux,
    Materia,
    Minty,
    Morph,
    Pulse,
    Quartz,
    Sandstone,
    Simplex,
    Sketchy,
    Slate,
    Solar,
    Spacelab,
    Superhero,
    United,
    Vapor,
    Yeti,
    Zephyr;

    private static final String CDN_PATTERN = "////cdn.jsdelivr.net/npm/bootswatch@%s/dist/%s/bootstrap%s.min.css";
    private final String cdnUrl;
    private final ResourceReference reference;
    private final String rtlCdnUrl;
    private final ResourceReference rtlReference;

    private BootswatchTheme() {
        String lName = this.name().toLowerCase(Locale.ROOT);
        this.cdnUrl = String.format(CDN_PATTERN, this.getBootstrapVersion(), lName, "");
        this.reference = new BootswatchCssReference(lName);
        String dot = ".";
        String rtl = "rtl";
        String rtlName = rtl + dot + lName;
        this.rtlCdnUrl = String.format(CDN_PATTERN, this.getBootstrapVersion(), lName, dot + rtl);
        this.rtlReference = new BootswatchCssReference(rtlName);
    }

    private boolean isRtl() {
        return WebSession.exists() && WebSession.get().isRtlLocale();
    }

    public Iterable<String> getCdnUrls() {
        return List.of();
    }

    public List<HeaderItem> getDependencies() {
        Object ref = this.useCdnResources() ? new UrlResourceReference(Url.parse((CharSequence)(this.isRtl() ? this.rtlCdnUrl : this.cdnUrl))) : (this.isRtl() ? this.rtlReference : this.reference);
        return List.of(CssHeaderItem.forReference((ResourceReference)ref).setId("wb-theme"));
    }

    public void renderHead(IHeaderResponse response) {
        for (HeaderItem headerItem : this.getDependencies()) {
            response.render(headerItem);
        }
    }

    private boolean useCdnResources() {
        IBootstrapSettings settings;
        boolean result = false;
        if (Application.exists() && (settings = Bootstrap.getSettings()) != null) {
            result = settings.useCdnResources();
        }
        return result;
    }

    private String getBootstrapVersion() {
        IBootstrapSettings settings;
        String version = "5.3.5";
        if (Application.exists() && (settings = Bootstrap.getSettings()) != null) {
            version = settings.getVersion();
        }
        return version;
    }
}

