/*
 * Decompiled with CFR 0.152.
 */
package de.crowdcode.kissmda.cartridges.simplejava;

import de.crowdcode.kissmda.cartridges.simplejava.InterfaceGenerator;
import de.crowdcode.kissmda.cartridges.simplejava.PackageComment;
import de.crowdcode.kissmda.core.jdt.JdtHelper;
import de.crowdcode.kissmda.core.uml.PackageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;

public class EnumGenerator {
    private static final Logger logger = Logger.getLogger(EnumGenerator.class.getName());
    @Inject
    private PackageHelper packageHelper;
    @Inject
    private InterfaceGenerator interfaceGenerator;
    @Inject
    private JdtHelper jdtHelper;
    private String sourceDirectoryPackageName;
    private ArrayList<String> constructorParameterNames = new ArrayList();

    public void setConstructorParameterNames(ArrayList<String> constructorParameterNames) {
        this.constructorParameterNames = constructorParameterNames;
    }

    public CompilationUnit generateEnum(Classifier clazz, String sourceDirectoryPackageName) {
        this.sourceDirectoryPackageName = sourceDirectoryPackageName;
        AST ast = AST.newAST((int)3);
        CompilationUnit cu = ast.newCompilationUnit();
        this.generatePackage(clazz, ast, cu);
        EnumDeclaration ed = this.generateEnum(clazz, ast, cu);
        this.generateAttributes(clazz, ast, ed);
        this.generateConstructor(clazz, ast, ed);
        this.generateConstants(clazz, ast, ed);
        this.generateGetterMethod(clazz, ast, ed);
        logger.log(Level.INFO, "Compilation unit: \n\n" + cu.toString());
        return cu;
    }

    public void generateAttributes(Classifier clazz, AST ast, EnumDeclaration ed) {
        EList properties = clazz.getAttributes();
        for (Property property : properties) {
            ed.bodyDeclarations().add(this.generateAttribute(clazz, ast, property));
        }
    }

    public FieldDeclaration generateAttribute(Classifier clazz, AST ast, Property property) {
        Type type = property.getType();
        logger.log(Level.FINE, "Class: " + clazz.getName() + " - Property: " + property.getName() + " - Property Upper: " + property.getUpper() + " - Property Lower: " + property.getLower());
        String umlTypeName = type.getName();
        String umlQualifiedTypeName = type.getQualifiedName();
        org.eclipse.jdt.core.dom.Type chosenType = this.jdtHelper.getChosenType(ast, umlTypeName, umlQualifiedTypeName, this.sourceDirectoryPackageName);
        VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
        SimpleName variableName = ast.newSimpleName(property.getName());
        fragment.setName(variableName);
        FieldDeclaration fieldDeclaration = ast.newFieldDeclaration(fragment);
        fieldDeclaration.setType(chosenType);
        EList comments = property.getOwnedComments();
        for (Comment comment : comments) {
            Javadoc javadoc = ast.newJavadoc();
            this.generateJavadoc(ast, comment, javadoc);
            fieldDeclaration.setJavadoc(javadoc);
        }
        return fieldDeclaration;
    }

    private void generateJavadoc(AST ast, Comment comment, Javadoc javadoc) {
        String[] commentContents;
        for (String commentContent : commentContents = this.parseComment(comment.getBody())) {
            TagElement tagElement = ast.newTagElement();
            tagElement.setTagName(commentContent);
            javadoc.tags().add(tagElement);
        }
    }

    private String[] parseComment(String body) {
        String[] lines = body.split("\\r?\\n");
        return lines;
    }

    public void generateGetterMethod(Classifier clazz, AST ast, EnumDeclaration ed) {
        EList properties = clazz.getAttributes();
        for (Property property : properties) {
            Type type = property.getType();
            logger.log(Level.FINE, "Class: " + clazz.getName() + " - Property: " + property.getName() + " - Property Upper: " + property.getUpper() + " - Property Lower: " + property.getLower());
            String umlTypeName = type.getName();
            String umlQualifiedTypeName = type.getQualifiedName();
            MethodDeclaration methodDeclaration = this.interfaceGenerator.generateGetterMethod(ast, (AbstractTypeDeclaration)ed, property, umlTypeName, umlQualifiedTypeName, this.sourceDirectoryPackageName);
            methodDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
            Block block = ast.newBlock();
            ReturnStatement returnStatement = ast.newReturnStatement();
            SimpleName simpleName = ast.newSimpleName(property.getName());
            returnStatement.setExpression((Expression)simpleName);
            block.statements().add(returnStatement);
            methodDeclaration.setBody(block);
        }
    }

    public void generateGetterMethod(Classifier clazz, AST ast, EnumDeclaration ed, String sourceDirectoryPackageName) {
        this.sourceDirectoryPackageName = sourceDirectoryPackageName;
        this.generateGetterMethod(clazz, ast, ed);
    }

    public void generateConstructor(Classifier clazz, AST ast, EnumDeclaration ed) {
        MethodDeclaration md = ast.newMethodDeclaration();
        md.setConstructor(true);
        md.setName(ast.newSimpleName(clazz.getName()));
        md.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD));
        ed.bodyDeclarations().add(md);
        this.generateContructorParameters(clazz, ast, md);
        Block block = ast.newBlock();
        EList properties = clazz.getAttributes();
        for (Property property : properties) {
            logger.log(Level.FINE, "Class: " + clazz.getName() + " - Property: " + property.getName() + " - Property Upper: " + property.getUpper() + " - Property Lower: " + property.getLower());
            SimpleName simpleName = ast.newSimpleName(property.getName());
            ThisExpression thisExpression = ast.newThisExpression();
            FieldAccess fieldAccess = ast.newFieldAccess();
            fieldAccess.setName(simpleName);
            fieldAccess.setExpression((Expression)thisExpression);
            SimpleName parameter = ast.newSimpleName(property.getName());
            Assignment assignment = ast.newAssignment();
            assignment.setOperator(Assignment.Operator.ASSIGN);
            assignment.setLeftHandSide((Expression)fieldAccess);
            assignment.setRightHandSide((Expression)parameter);
            ExpressionStatement expressionStatement = ast.newExpressionStatement((Expression)assignment);
            block.statements().add(expressionStatement);
        }
        md.setBody(block);
    }

    void generateContructorParameters(Classifier clazz, AST ast, MethodDeclaration md) {
        this.constructorParameterNames.clear();
        EList constructorProperties = clazz.getAttributes();
        for (Property constructorProperty : constructorProperties) {
            Type constructorType = constructorProperty.getType();
            this.constructorParameterNames.add(constructorProperty.getName());
            logger.log(Level.FINE, "Class: " + clazz.getName() + " - Constructor property: " + constructorProperty.getName() + " - Constructor property Upper: " + constructorProperty.getUpper() + " - Constructor property Lower: " + constructorProperty.getLower());
            String contructorUmlTypeName = constructorType.getName();
            String constructorUmlQualifiedTypeName = constructorType.getQualifiedName();
            org.eclipse.jdt.core.dom.Type constructorChosenType = this.jdtHelper.getChosenType(ast, contructorUmlTypeName, constructorUmlQualifiedTypeName, this.sourceDirectoryPackageName);
            SingleVariableDeclaration variableDeclaration = ast.newSingleVariableDeclaration();
            variableDeclaration.setType(constructorChosenType);
            variableDeclaration.setName(ast.newSimpleName(constructorProperty.getName()));
            md.parameters().add(variableDeclaration);
        }
    }

    public EnumDeclaration generateEnum(Classifier clazz, AST ast, CompilationUnit cu) {
        String className = this.getClassName(clazz);
        EnumDeclaration ed = ast.newEnumDeclaration();
        ed.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        ed.setName(ast.newSimpleName(className));
        this.generateClassJavadoc((Element)clazz, ast, (BodyDeclaration)ed);
        cu.types().add(ed);
        return ed;
    }

    public void generateClassJavadoc(Element clazz, AST ast, BodyDeclaration td) {
        EList comments = clazz.getOwnedComments();
        if (comments != null) {
            for (Comment comment : comments) {
                Javadoc javadoc = ast.newJavadoc();
                this.generateJavadoc(ast, comment, javadoc);
                td.setJavadoc(javadoc);
            }
        }
    }

    public void generatePackage(Classifier clazz, AST ast, CompilationUnit cu) {
        PackageDeclaration pd = ast.newPackageDeclaration();
        String fullPackageName = this.getFullPackageName(clazz);
        pd.setName(ast.newName(fullPackageName));
        Date now = new Date();
        String commentDate = "Generation date: " + now.toString() + ".";
        this.interfaceGenerator.generatePackageJavadoc(ast, pd, PackageComment.CONTENT_1.getValue(), PackageComment.CONTENT_2.getValue(), " ", PackageComment.CONTENT_3.getValue(), " ", commentDate);
        cu.setPackage(pd);
    }

    public void generateConstants(Classifier clazz, AST ast, EnumDeclaration ed) {
        Enumeration enumeration = (Enumeration)clazz;
        EList enumerationLiterals = enumeration.getOwnedLiterals();
        for (EnumerationLiteral enumLiteral : enumerationLiterals) {
            EnumConstantDeclaration ec = ast.newEnumConstantDeclaration();
            ec.setName(ast.newSimpleName(enumLiteral.getName().toUpperCase()));
            this.generateClassJavadoc((Element)enumLiteral, ast, (BodyDeclaration)ec);
            if (!this.constructorParameterNames.isEmpty()) {
                for (String constructorParameterName : this.constructorParameterNames) {
                    logger.log(Level.FINE, "constructorParameterName: " + this.constructorParameterNames.toString());
                    Slot slot = this.findSlotByName(constructorParameterName, enumLiteral);
                    if (slot != null) {
                        Property property = (Property)slot.getDefiningFeature();
                        Type type = property.getType();
                        this.chooseLiteralTypeAndAddToEnumConstantArguments(ast, ec, slot, type);
                        continue;
                    }
                    logger.log(Level.SEVERE, "EnumGenerator: Error in Generating Enum: we cannot find the correct slot by its name as it was given by the constructor!");
                    this.getSlotsNotIntelligent(ast, enumLiteral, ec);
                }
            } else {
                this.getSlotsNotIntelligent(ast, enumLiteral, ec);
            }
            ed.enumConstants().add(ec);
        }
    }

    private void getSlotsNotIntelligent(AST ast, EnumerationLiteral enumLiteral, EnumConstantDeclaration ec) {
        EList slots = enumLiteral.getSlots();
        for (Slot slot : slots) {
            Property property = (Property)slot.getDefiningFeature();
            Type type = property.getType();
            this.chooseLiteralTypeAndAddToEnumConstantArguments(ast, ec, slot, type);
        }
    }

    void chooseLiteralTypeAndAddToEnumConstantArguments(AST ast, EnumConstantDeclaration ec, Slot slot, Type type) {
        EList valueSpecifications = slot.getValues();
        for (ValueSpecification valueSpecification : valueSpecifications) {
            NumberLiteral numberLiteral;
            if (type.getName().equalsIgnoreCase("Integer")) {
                numberLiteral = ast.newNumberLiteral();
                numberLiteral.setToken(String.valueOf(valueSpecification.integerValue()));
                ec.arguments().add(numberLiteral);
                continue;
            }
            if (type.getName().equalsIgnoreCase("Long")) {
                numberLiteral = ast.newNumberLiteral();
                numberLiteral.setToken(String.valueOf(valueSpecification.integerValue()).concat("L"));
                ec.arguments().add(numberLiteral);
                continue;
            }
            if (type.getName().equalsIgnoreCase("Boolean")) {
                BooleanLiteral booleanLiteral = ast.newBooleanLiteral(valueSpecification.booleanValue());
                ec.arguments().add(booleanLiteral);
                continue;
            }
            if (!type.getName().equalsIgnoreCase("String")) continue;
            StringLiteral stringLiteral = ast.newStringLiteral();
            stringLiteral.setLiteralValue(valueSpecification.stringValue());
            ec.arguments().add(stringLiteral);
        }
    }

    Slot findSlotByName(String name, EnumerationLiteral enumLiteral) {
        EList slots = enumLiteral.getSlots();
        for (Slot slot : slots) {
            Property property = (Property)slot.getDefiningFeature();
            String slotPropertyName = property.getName();
            if (!slotPropertyName.equals(name)) continue;
            return slot;
        }
        return null;
    }

    private String getClassName(Classifier clazz) {
        String className = clazz.getName();
        return className;
    }

    private String getFullPackageName(Classifier clazz) {
        String fullPackageName = this.packageHelper.getFullPackageName(clazz, this.sourceDirectoryPackageName);
        return fullPackageName;
    }
}

