/*
 * Decompiled with CFR 0.152.
 */
package de.crowdcode.kissmda.cartridges.simplejava;

import de.crowdcode.kissmda.cartridges.simplejava.InterfaceGenerator;
import de.crowdcode.kissmda.cartridges.simplejava.PackageComment;
import de.crowdcode.kissmda.core.TransformerException;
import de.crowdcode.kissmda.core.jdt.JdtHelper;
import de.crowdcode.kissmda.core.uml.PackageHelper;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Generalization;

public class ExceptionGenerator {
    private static final Logger logger = Logger.getLogger(ExceptionGenerator.class.getName());
    @Inject
    private InterfaceGenerator interfaceGenerator;
    @Inject
    private PackageHelper packageHelper;
    @Inject
    private JdtHelper jdtHelper;
    private String sourceDirectoryPackageName;
    private boolean isCheckedException = true;

    public void setCheckedException(boolean isCheckedException) {
        this.isCheckedException = isCheckedException;
    }

    public CompilationUnit generateCheckedException(Classifier clazz, String sourceDirectoryPackageName) {
        this.sourceDirectoryPackageName = sourceDirectoryPackageName;
        this.isCheckedException = true;
        CompilationUnit cu = this.generateException(clazz);
        return cu;
    }

    public CompilationUnit generateUncheckedException(Classifier clazz, String sourceDirectoryPackageName) {
        this.sourceDirectoryPackageName = sourceDirectoryPackageName;
        this.isCheckedException = false;
        CompilationUnit cu = this.generateException(clazz);
        return cu;
    }

    private CompilationUnit generateException(Classifier clazz) {
        AST ast = AST.newAST((int)3);
        CompilationUnit cu = ast.newCompilationUnit();
        this.generatePackage(clazz, ast, cu);
        TypeDeclaration td = this.generateClass(clazz, ast, cu);
        this.generateSerialVersionUID(clazz, ast, td);
        this.generateMethods(clazz, ast, td);
        this.generateConstructors(clazz, ast, td);
        logger.log(Level.INFO, "Compilation unit: \n\n" + cu.toString());
        return cu;
    }

    public void generateSerialVersionUID(Classifier clazz, AST ast, TypeDeclaration td) {
        VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
        SimpleName variableName = ast.newSimpleName("serialVersionUID");
        fragment.setName(variableName);
        NumberLiteral initializer = ast.newNumberLiteral();
        initializer.setToken("1L");
        fragment.setInitializer((Expression)initializer);
        FieldDeclaration fieldDeclaration = ast.newFieldDeclaration(fragment);
        fieldDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD));
        fieldDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        fieldDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
        fieldDeclaration.setType((Type)ast.newPrimitiveType(PrimitiveType.LONG));
        td.bodyDeclarations().add(fieldDeclaration);
    }

    public TypeDeclaration generateClass(Classifier clazz, AST ast, CompilationUnit cu) {
        String className = this.getClassName(clazz);
        TypeDeclaration td = ast.newTypeDeclaration();
        td.setInterface(false);
        td.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        td.setName(ast.newSimpleName(className));
        this.generateClassInheritance(clazz, ast, td);
        this.generateClassTemplateParams(clazz, ast, td);
        cu.types().add(td);
        return td;
    }

    private void generateClassTemplateParams(Classifier clazz, AST ast, TypeDeclaration td) {
        this.interfaceGenerator.generateClassTemplateParams(clazz, ast, td);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateClassInheritance(Classifier clazz, AST ast, TypeDeclaration td) {
        EList generalizations = clazz.getGeneralizations();
        if (generalizations == null) return;
        if (!generalizations.isEmpty()) {
            if (generalizations.size() != 1) throw new TransformerException("Java only supports single inheritance! Wrong modeling in class: " + clazz.getQualifiedName());
            for (Generalization generalization : generalizations) {
                Classifier interfaceClassifier = generalization.getGeneral();
                String fullQualifiedInterfaceName = interfaceClassifier.getQualifiedName();
                Name name = this.jdtHelper.createFullQualifiedTypeAsName(ast, fullQualifiedInterfaceName, this.sourceDirectoryPackageName);
                SimpleType simpleType = ast.newSimpleType(name);
                td.setSuperclassType((Type)simpleType);
            }
            return;
        } else {
            String exceptionToBeInherited = "Exception";
            if (!this.isCheckedException) {
                exceptionToBeInherited = "RuntimeException";
            }
            SimpleType simpleType = ast.newSimpleType((Name)ast.newSimpleName(exceptionToBeInherited));
            td.setSuperclassType((Type)simpleType);
        }
    }

    private void generatePackage(Classifier clazz, AST ast, CompilationUnit cu) {
        PackageDeclaration pd = ast.newPackageDeclaration();
        String fullPackageName = this.getFullPackageName(clazz);
        pd.setName(ast.newName(fullPackageName));
        Date now = new Date();
        String commentDate = "Generation date: " + now.toString() + ".";
        this.interfaceGenerator.generatePackageJavadoc(ast, pd, PackageComment.CONTENT_1.getValue(), PackageComment.CONTENT_2.getValue(), " ", PackageComment.CONTENT_3.getValue(), " ", commentDate);
        cu.setPackage(pd);
    }

    private void generateMethods(Classifier clazz, AST ast, TypeDeclaration td) {
        this.interfaceGenerator.generateMethods(clazz, ast, td);
    }

    public void generateConstructors(Classifier clazz, AST ast, TypeDeclaration td) {
        this.generateConstructorDefault(clazz, ast, td);
        this.generateConstructorWithParams(clazz, ast, td, new String[]{"Throwable"}, new String[]{"cause"});
        this.generateConstructorWithParams(clazz, ast, td, new String[]{"String"}, new String[]{"message"});
        this.generateConstructorWithParams(clazz, ast, td, new String[]{"String", "Throwable"}, new String[]{"message", "cause"});
    }

    public void generateConstructorWithParams(Classifier clazz, AST ast, TypeDeclaration td, String[] varTypes, String[] varNames) {
        MethodDeclaration constructor = ast.newMethodDeclaration();
        constructor.setConstructor(true);
        constructor.setName(ast.newSimpleName(clazz.getName()));
        constructor.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        for (int index = 0; index < varTypes.length; ++index) {
            SingleVariableDeclaration variableDeclaration = ast.newSingleVariableDeclaration();
            variableDeclaration.setType((Type)ast.newSimpleType((Name)ast.newSimpleName(varTypes[index])));
            variableDeclaration.setName(ast.newSimpleName(varNames[index]));
            constructor.parameters().add(variableDeclaration);
        }
        Block block = ast.newBlock();
        SuperConstructorInvocation constructorInvocation = ast.newSuperConstructorInvocation();
        for (int index = 0; index < varNames.length; ++index) {
            constructorInvocation.arguments().add(ast.newSimpleName(varNames[index]));
        }
        block.statements().add(constructorInvocation);
        constructor.setBody(block);
        td.bodyDeclarations().add(constructor);
    }

    private void generateConstructorDefault(Classifier clazz, AST ast, TypeDeclaration td) {
        MethodDeclaration constructor = ast.newMethodDeclaration();
        constructor.setConstructor(true);
        constructor.setName(ast.newSimpleName(clazz.getName()));
        constructor.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        Block block = ast.newBlock();
        constructor.setBody(block);
        td.bodyDeclarations().add(constructor);
    }

    private String getClassName(Classifier clazz) {
        String className = clazz.getName();
        return className;
    }

    private String getFullPackageName(Classifier clazz) {
        String fullPackageName = this.packageHelper.getFullPackageName(clazz, this.sourceDirectoryPackageName);
        return fullPackageName;
    }
}

