/*
 * Decompiled with CFR 0.152.
 */
package de.crowdcode.kissmda.cartridges.simplejava;

import de.crowdcode.kissmda.cartridges.simplejava.PackageComment;
import de.crowdcode.kissmda.core.jdt.DataTypeUtils;
import de.crowdcode.kissmda.core.jdt.JdtHelper;
import de.crowdcode.kissmda.core.jdt.MethodHelper;
import de.crowdcode.kissmda.core.uml.PackageHelper;
import de.crowdcode.kissmda.core.uml.UmlHelper;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.Type;

public class InterfaceGenerator {
    private static final Logger logger = Logger.getLogger(InterfaceGenerator.class.getName());
    @Inject
    private MethodHelper methodHelper;
    @Inject
    private JdtHelper jdtHelper;
    @Inject
    private PackageHelper packageHelper;
    @Inject
    private UmlHelper umlHelper;
    @Inject
    private DataTypeUtils dataTypeUtils;
    private String sourceDirectoryPackageName;

    public CompilationUnit generateInterface(Classifier clazz, String sourceDirectoryPackageName) {
        this.sourceDirectoryPackageName = sourceDirectoryPackageName;
        logger.log(Level.FINE, "Start generateInterface: " + clazz.getName() + " -----------------------------");
        AST ast = AST.newAST((int)3);
        CompilationUnit cu = ast.newCompilationUnit();
        this.generatePackage(clazz, ast, cu);
        TypeDeclaration td = this.generateClass(clazz, ast, cu);
        this.generateMethods(clazz, ast, td);
        this.generateGettersSetters(clazz, ast, td);
        logger.log(Level.INFO, "Compilation unit: \n\n" + cu.toString());
        logger.log(Level.FINE, "End generateInterface: " + clazz.getName() + " -----------------------------");
        return cu;
    }

    public void generatePackageJavadoc(AST ast, PackageDeclaration packageDeclaration, String ... comment) {
        Javadoc javadoc = ast.newJavadoc();
        for (String actualComment : comment) {
            TagElement tagElement = ast.newTagElement();
            tagElement.setTagName(actualComment);
            javadoc.tags().add(tagElement);
        }
        packageDeclaration.setJavadoc(javadoc);
    }

    public void generateGettersSetters(Classifier clazz, AST ast, TypeDeclaration td) {
        EList properties = clazz.getAttributes();
        for (Property property : properties) {
            Type type = property.getType();
            logger.log(Level.FINE, "Class: " + clazz.getName() + " - Property: " + property.getName() + " - Property Upper: " + property.getUpper() + " - Property Lower: " + property.getLower());
            String umlTypeName = type.getName();
            String umlQualifiedTypeName = type.getQualifiedName();
            if (this.dataTypeUtils.isParameterizedType(umlTypeName)) {
                Map types = this.umlHelper.checkParameterizedTypeForTemplateParameterSubstitution(type);
                umlTypeName = (String)types.get("umlTypeName");
                umlQualifiedTypeName = (String)types.get("umlQualifiedTypeName");
            }
            if (property.getName().equals("")) {
                Type targetType = property.getType();
                String newPropertyName = "";
                newPropertyName = property.getUpper() >= 0 ? targetType.getName() : this.methodHelper.getPluralName(targetType.getName());
                property.setName(StringUtils.uncapitalize((String)newPropertyName));
            }
            this.generateGetterMethod(ast, (AbstractTypeDeclaration)td, property, umlTypeName, umlQualifiedTypeName);
            if (property.isReadOnly()) continue;
            this.generateSetterMethod(ast, (AbstractTypeDeclaration)td, property, umlTypeName, umlQualifiedTypeName);
        }
    }

    public MethodDeclaration generateGetterMethod(AST ast, AbstractTypeDeclaration td, Property property, String umlTypeName, String umlQualifiedTypeName) {
        MethodDeclaration mdGetter = ast.newMethodDeclaration();
        String getterName = this.methodHelper.getGetterName(property.getName());
        if (umlTypeName.equalsIgnoreCase("boolean")) {
            getterName = this.methodHelper.getIsName(property.getName());
        }
        mdGetter.setName(ast.newSimpleName(getterName));
        if (property.getUpper() >= 0) {
            this.jdtHelper.createReturnType(ast, td, mdGetter, umlTypeName, umlQualifiedTypeName, this.sourceDirectoryPackageName);
        } else {
            this.generateAssociationEndUpperCardinalityMultiples(ast, td, property, mdGetter, umlTypeName, umlQualifiedTypeName);
        }
        this.generateGetterSetterJavadoc(ast, property, mdGetter);
        return mdGetter;
    }

    public MethodDeclaration generateGetterMethod(AST ast, AbstractTypeDeclaration td, Property property, String umlTypeName, String umlQualifiedTypeName, String sourceDirectoryPackageName) {
        this.sourceDirectoryPackageName = sourceDirectoryPackageName;
        return this.generateGetterMethod(ast, td, property, umlTypeName, umlQualifiedTypeName);
    }

    public void generateSetterMethod(AST ast, AbstractTypeDeclaration td, Property property, String umlTypeName, String umlQualifiedTypeName) {
        MethodDeclaration mdSetter = ast.newMethodDeclaration();
        PrimitiveType primitiveType = this.jdtHelper.getAstPrimitiveType(ast, "void");
        mdSetter.setReturnType2((org.eclipse.jdt.core.dom.Type)primitiveType);
        td.bodyDeclarations().add(mdSetter);
        String umlPropertyName = property.getName();
        if (property.getUpper() >= 0) {
            String setterName = this.methodHelper.getSetterName(property.getName());
            mdSetter.setName(ast.newSimpleName(setterName));
            this.jdtHelper.createParameterTypes(ast, td, mdSetter, umlTypeName, umlQualifiedTypeName, umlPropertyName, this.sourceDirectoryPackageName);
        } else {
            String singularAdderName = this.methodHelper.getSingularName(property.getName());
            String adderName = this.methodHelper.getAdderName(singularAdderName);
            umlPropertyName = this.methodHelper.getSingularName(umlPropertyName);
            mdSetter.setName(ast.newSimpleName(adderName));
            this.jdtHelper.createParameterTypes(ast, td, mdSetter, umlTypeName, umlQualifiedTypeName, umlPropertyName, this.sourceDirectoryPackageName);
        }
        this.generateGetterSetterJavadoc(ast, property, mdSetter);
    }

    public void generateAssociationEndUpperCardinalityMultiples(AST ast, AbstractTypeDeclaration td, Property property, MethodDeclaration mdGetter, String umlTypeName, String umlQualifiedTypeName) {
        if (property.isOrdered() && !property.isUnique()) {
            this.jdtHelper.createReturnTypeAsCollection(ast, td, mdGetter, umlTypeName, umlQualifiedTypeName, this.sourceDirectoryPackageName, "java.util.List");
        } else if (property.isUnique() && !property.isOrdered()) {
            this.jdtHelper.createReturnTypeAsCollection(ast, td, mdGetter, umlTypeName, umlQualifiedTypeName, this.sourceDirectoryPackageName, "java.util.Set");
        } else if (property.isUnique() && property.isOrdered()) {
            this.jdtHelper.createReturnTypeAsCollection(ast, td, mdGetter, umlTypeName, umlQualifiedTypeName, this.sourceDirectoryPackageName, "java.util.SortedSet");
        } else {
            this.jdtHelper.createReturnTypeAsCollection(ast, td, mdGetter, umlTypeName, umlQualifiedTypeName, this.sourceDirectoryPackageName, "java.util.Collection");
        }
    }

    public void generateAssociationEndUpperCardinalityMultiples(AST ast, AbstractTypeDeclaration td, Operation operation, MethodDeclaration mdGetter, String umlTypeName, String umlQualifiedTypeName) {
        if (operation.isOrdered() && !operation.isUnique()) {
            this.jdtHelper.createReturnTypeAsCollection(ast, td, mdGetter, umlTypeName, umlQualifiedTypeName, this.sourceDirectoryPackageName, "java.util.List");
        } else if (operation.isUnique() && !operation.isOrdered()) {
            this.jdtHelper.createReturnTypeAsCollection(ast, td, mdGetter, umlTypeName, umlQualifiedTypeName, this.sourceDirectoryPackageName, "java.util.Set");
        } else if (operation.isUnique() && operation.isOrdered()) {
            this.jdtHelper.createReturnTypeAsCollection(ast, td, mdGetter, umlTypeName, umlQualifiedTypeName, this.sourceDirectoryPackageName, "java.util.SortedSet");
        } else {
            this.jdtHelper.createReturnTypeAsCollection(ast, td, mdGetter, umlTypeName, umlQualifiedTypeName, this.sourceDirectoryPackageName, "java.util.Collection");
        }
    }

    public void generateAssociationEndUpperCardinalityMultiples(AST ast, AbstractTypeDeclaration td, Parameter parameter, MethodDeclaration md, String umlTypeName, String umlQualifiedTypeName, String umlPropertyName) {
        if (parameter.isOrdered() && !parameter.isUnique()) {
            this.jdtHelper.createParameterTypesAsCollection(ast, td, md, umlTypeName, umlQualifiedTypeName, umlPropertyName, this.sourceDirectoryPackageName, "java.util.List");
        } else if (parameter.isUnique() && !parameter.isOrdered()) {
            this.jdtHelper.createParameterTypesAsCollection(ast, td, md, umlTypeName, umlQualifiedTypeName, umlPropertyName, this.sourceDirectoryPackageName, "java.util.Set");
        } else if (parameter.isUnique() && parameter.isOrdered()) {
            this.jdtHelper.createParameterTypesAsCollection(ast, td, md, umlTypeName, umlQualifiedTypeName, umlPropertyName, this.sourceDirectoryPackageName, "java.util.SortedSet");
        } else {
            this.jdtHelper.createParameterTypesAsCollection(ast, td, md, umlTypeName, umlQualifiedTypeName, umlPropertyName, this.sourceDirectoryPackageName, "java.util.Collection");
        }
    }

    public void generateGetterSetterJavadoc(AST ast, Property property, MethodDeclaration methodDeclaration) {
        EList comments = property.getOwnedComments();
        for (Comment comment : comments) {
            Javadoc javadoc = ast.newJavadoc();
            this.generateJavadoc(ast, comment, javadoc);
            methodDeclaration.setJavadoc(javadoc);
        }
    }

    public TypeDeclaration generateClass(Classifier clazz, AST ast, CompilationUnit cu) {
        String className = this.getClassName(clazz);
        TypeDeclaration td = ast.newTypeDeclaration();
        td.setInterface(true);
        td.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        td.setName(ast.newSimpleName(className));
        this.generateClassInheritance(clazz, ast, td);
        this.generateClassTemplateParams(clazz, ast, td);
        this.generateClassJavadoc(clazz, ast, (AbstractTypeDeclaration)td);
        cu.types().add(td);
        return td;
    }

    public void generateClassJavadoc(Classifier clazz, AST ast, AbstractTypeDeclaration td) {
        EList comments = clazz.getOwnedComments();
        for (Comment comment : comments) {
            Javadoc javadoc = ast.newJavadoc();
            this.generateJavadoc(ast, comment, javadoc);
            td.setJavadoc(javadoc);
        }
    }

    public void generateClassTemplateParams(Classifier clazz, AST ast, TypeDeclaration td) {
        TemplateSignature templateSignature = clazz.getOwnedTemplateSignature();
        if (templateSignature != null) {
            EList templateParameters = templateSignature.getParameters();
            for (TemplateParameter templateParameter : templateParameters) {
                Classifier classifier = (Classifier)templateParameter.getOwnedParameteredElement();
                String typeName = classifier.getLabel();
                TypeParameter typeParameter = ast.newTypeParameter();
                typeParameter.setName(ast.newSimpleName(typeName));
                td.typeParameters().add(typeParameter);
            }
        }
    }

    private void generateClassInheritance(Classifier clazz, AST ast, TypeDeclaration td) {
        EList generalizations = clazz.getGeneralizations();
        if (generalizations != null) {
            for (Generalization generalization : generalizations) {
                Classifier interfaceClassifier = generalization.getGeneral();
                String fullQualifiedInterfaceName = interfaceClassifier.getQualifiedName();
                Name name = this.jdtHelper.createFullQualifiedTypeAsName(ast, fullQualifiedInterfaceName, this.sourceDirectoryPackageName);
                SimpleType simpleType = ast.newSimpleType(name);
                td.superInterfaceTypes().add(simpleType);
            }
        }
    }

    public void generatePackage(Classifier clazz, AST ast, CompilationUnit cu) {
        PackageDeclaration pd = ast.newPackageDeclaration();
        String fullPackageName = this.getFullPackageName(clazz);
        pd.setName(ast.newName(fullPackageName));
        Date now = new Date();
        String commentDate = "Generation date: " + now.toString() + ".";
        this.generatePackageJavadoc(ast, pd, PackageComment.CONTENT_1.getValue(), PackageComment.CONTENT_2.getValue(), " ", PackageComment.CONTENT_3.getValue(), " ", commentDate);
        cu.setPackage(pd);
    }

    public void generateMethods(Classifier clazz, AST ast, TypeDeclaration td) {
        EList operations = clazz.getOperations();
        for (Operation operation : operations) {
            logger.log(Level.FINE, "Operation: " + operation.getName());
            MethodDeclaration md = ast.newMethodDeclaration();
            md.setName(ast.newSimpleName(operation.getName()));
            this.generateMethodParams(ast, td, operation, md);
            this.generateMethodReturnType(ast, td, operation, md);
            this.generateMethodThrowException(ast, operation, md);
            this.generateMethodJavadoc(ast, operation, md);
            this.generateMethodTemplateParams(ast, operation, md);
        }
    }

    public void generateMethodTemplateParams(AST ast, Operation operation, MethodDeclaration md) {
        TemplateSignature templateSignature = operation.getOwnedTemplateSignature();
        if (templateSignature != null) {
            EList templateParameters = templateSignature.getParameters();
            for (TemplateParameter templateParameter : templateParameters) {
                Classifier classifier = (Classifier)templateParameter.getOwnedParameteredElement();
                String typeName = classifier.getLabel();
                TypeParameter typeParameter = ast.newTypeParameter();
                typeParameter.setName(ast.newSimpleName(typeName));
                md.typeParameters().add(typeParameter);
            }
        }
    }

    public void generateMethodJavadoc(AST ast, Operation operation, MethodDeclaration md) {
        EList comments = operation.getOwnedComments();
        for (Comment comment : comments) {
            Javadoc javadoc = ast.newJavadoc();
            this.generateJavadoc(ast, comment, javadoc);
            md.setJavadoc(javadoc);
        }
    }

    private void generateJavadoc(AST ast, Comment comment, Javadoc javadoc) {
        String[] commentContents;
        for (String commentContent : commentContents = this.parseComent(comment.getBody())) {
            TagElement tagElement = ast.newTagElement();
            tagElement.setTagName(commentContent);
            javadoc.tags().add(tagElement);
        }
    }

    private String[] parseComent(String body) {
        String[] lines = body.split("\\r?\\n");
        return lines;
    }

    private void generateMethodThrowException(AST ast, Operation operation, MethodDeclaration md) {
        EList raisedExceptions = operation.getRaisedExceptions();
        for (Type raisedExceptionType : raisedExceptions) {
            String umlExceptionQualifiedTypeName = raisedExceptionType.getQualifiedName();
            String name = this.jdtHelper.createFullQualifiedTypeAsString(ast, umlExceptionQualifiedTypeName, this.sourceDirectoryPackageName);
            Name typeName = ast.newName(name);
            md.thrownExceptions().add(typeName);
        }
    }

    private void generateMethodReturnType(AST ast, TypeDeclaration td, Operation operation, MethodDeclaration md) {
        Type type = operation.getType();
        String umlTypeName = type.getName();
        String umlQualifiedTypeName = type.getQualifiedName();
        logger.log(Level.FINE, "UmlQualifiedTypeName: " + umlQualifiedTypeName + " - umlTypeName: " + umlTypeName);
        if (operation.getUpper() >= 0) {
            if (this.dataTypeUtils.isParameterizedType(umlTypeName)) {
                Map types = this.umlHelper.checkParameterizedTypeForTemplateParameterSubstitution(type);
                umlTypeName = (String)types.get("umlTypeName");
                umlQualifiedTypeName = (String)types.get("umlQualifiedTypeName");
            }
            this.jdtHelper.createReturnType(ast, (AbstractTypeDeclaration)td, md, umlTypeName, umlQualifiedTypeName, this.sourceDirectoryPackageName);
        } else {
            this.generateAssociationEndUpperCardinalityMultiples(ast, (AbstractTypeDeclaration)td, operation, md, umlTypeName, umlQualifiedTypeName);
        }
    }

    public void generateMethodParams(AST ast, TypeDeclaration td, Operation operation, MethodDeclaration md) {
        EList parameters = operation.getOwnedParameters();
        for (Parameter parameter : parameters) {
            if (parameter.getDirection().getValue() == 3) continue;
            Type type = parameter.getType();
            String umlTypeName = type.getName();
            String umlQualifiedTypeName = type.getQualifiedName();
            String umlPropertyName = StringUtils.uncapitalize((String)parameter.getName());
            logger.log(Level.FINE, "Parameter: " + parameter.getName() + " - Type: " + umlTypeName);
            if (parameter.getUpper() >= 0) {
                if (this.dataTypeUtils.isParameterizedType(umlTypeName)) {
                    Map types = this.umlHelper.checkParameterizedTypeForTemplateParameterSubstitution(type);
                    umlTypeName = (String)types.get("umlTypeName");
                    umlQualifiedTypeName = (String)types.get("umlQualifiedTypeName");
                }
                this.jdtHelper.createParameterTypes(ast, (AbstractTypeDeclaration)td, md, umlTypeName, umlQualifiedTypeName, umlPropertyName, this.sourceDirectoryPackageName);
                continue;
            }
            this.generateAssociationEndUpperCardinalityMultiples(ast, (AbstractTypeDeclaration)td, parameter, md, umlTypeName, umlQualifiedTypeName, umlPropertyName);
        }
    }

    private String getClassName(Classifier clazz) {
        String className = clazz.getName();
        return className;
    }

    private String getFullPackageName(Classifier clazz) {
        String fullPackageName = this.packageHelper.getFullPackageName(clazz, this.sourceDirectoryPackageName);
        return fullPackageName;
    }
}

