/*
 * Decompiled with CFR 0.152.
 */
package de.crowdcode.kissmda.cartridges.simplejava;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class JavaCodeFormatter {
    private static final String JAVA_VERSION = "1.5";
    private static final Logger logger = Logger.getLogger(JavaCodeFormatter.class.getName());
    private static final String LINE_ENDING_AUTO = "AUTO";
    private static final String LINE_ENDING_KEEP = "KEEP";
    private static final String LINE_ENDING_LF = "LF";
    private static final String LINE_ENDING_CRLF = "CRLF";
    private static final String LINE_ENDING_CR = "CR";
    private static final String LINE_ENDING_LF_CHAR = "\n";
    private static final String LINE_ENDING_CRLF_CHARS = "\r\n";
    private static final String LINE_ENDING_CR_CHAR = "\r";
    private final String lineEnding = "AUTO";
    private CodeFormatter codeFormatter;

    private void createCodeFormatter() {
        Map<String, String> options = this.getFormattingOptions();
        this.codeFormatter = ToolFactory.createCodeFormatter(options);
    }

    private Map<String, String> getFormattingOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.eclipse.jdt.core.compiler.source", JAVA_VERSION);
        options.put("org.eclipse.jdt.core.compiler.compliance", JAVA_VERSION);
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", JAVA_VERSION);
        return options;
    }

    public String format(String compilationUnit) {
        this.createCodeFormatter();
        String lineSeparator = this.getLineEnding(compilationUnit);
        TextEdit te = this.codeFormatter.format(4104, compilationUnit, 0, compilationUnit.length(), 0, lineSeparator);
        Document doc = new Document(compilationUnit);
        try {
            te.apply((IDocument)doc);
        }
        catch (MalformedTreeException e) {
            logger.log(Level.SEVERE, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (BadLocationException e) {
            logger.log(Level.SEVERE, ExceptionUtils.getStackTrace((Throwable)e));
        }
        String formattedCode = doc.get();
        return formattedCode;
    }

    private String getLineEnding(String fileDataString) {
        String lineEnd = null;
        if (LINE_ENDING_KEEP.equals(LINE_ENDING_AUTO)) {
            lineEnd = this.determineLineEnding(fileDataString);
        } else if (LINE_ENDING_LF.equals(LINE_ENDING_AUTO)) {
            lineEnd = LINE_ENDING_LF_CHAR;
        } else if (LINE_ENDING_CRLF.equals(LINE_ENDING_AUTO)) {
            lineEnd = LINE_ENDING_CRLF_CHARS;
        } else if (LINE_ENDING_CR.equals(LINE_ENDING_AUTO)) {
            lineEnd = LINE_ENDING_CR_CHAR;
        }
        return lineEnd;
    }

    private String determineLineEnding(String fileDataString) {
        int lfCount = 0;
        int crCount = 0;
        int crlfCount = 0;
        for (int i = 0; i < fileDataString.length(); ++i) {
            char c = fileDataString.charAt(i);
            if (c == '\r') {
                if (i + 1 < fileDataString.length() && fileDataString.charAt(i + 1) == '\n') {
                    ++crlfCount;
                    ++i;
                    continue;
                }
                ++crCount;
                continue;
            }
            if (c != '\n') continue;
            ++lfCount;
        }
        if (lfCount > crCount && lfCount > crlfCount) {
            return LINE_ENDING_LF_CHAR;
        }
        if (crlfCount > lfCount && crlfCount > crCount) {
            return LINE_ENDING_CRLF_CHARS;
        }
        if (crCount > lfCount && crCount > crlfCount) {
            return LINE_ENDING_CR_CHAR;
        }
        return null;
    }
}

