/*
 * Decompiled with CFR 0.152.
 */
package de.crowdcode.kissmda.cartridges.simplejava;

import com.google.common.eventbus.EventBus;
import de.crowdcode.kissmda.cartridges.simplejava.EnumGenerator;
import de.crowdcode.kissmda.cartridges.simplejava.ExceptionGenerator;
import de.crowdcode.kissmda.cartridges.simplejava.InterfaceGenerator;
import de.crowdcode.kissmda.cartridges.simplejava.JavaCodeFormatter;
import de.crowdcode.kissmda.cartridges.simplejava.event.BeforeClassFileGeneratedEvent;
import de.crowdcode.kissmda.core.Context;
import de.crowdcode.kissmda.core.Transformer;
import de.crowdcode.kissmda.core.TransformerException;
import de.crowdcode.kissmda.core.file.JavaFileWriter;
import de.crowdcode.kissmda.core.uml.PackageHelper;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;

public class SimpleJavaTransformer
implements Transformer {
    private static final Logger logger = Logger.getLogger(SimpleJavaTransformer.class.getName());
    private static final String STEREOTYPE_ENTITY = "Entity";
    private static final String STEREOTYPE_SERVICE = "Service";
    private static final String STEREOTYPE_EXCEPTION = "Exception";
    private static final String STEREOTYPE_APPLICATIONEXCEPTION = "ApplicationException";
    private static final String STEREOTYPE_UNEXPECTEDEXCEPTION = "UnexpectedException";
    private static final String TYPE_ENUM = "Enumeration";
    private static final String STEREOTYPE_SOURCEDIRECTORY = "SourceDirectory";
    private String sourceDirectoryPackageName;
    @Inject
    private PackageHelper packageHelper;
    @Inject
    private JavaFileWriter javaFileWriter;
    @Inject
    private InterfaceGenerator interfaceGenerator;
    @Inject
    private ExceptionGenerator exceptionGenerator;
    @Inject
    private EnumGenerator enumGenerator;
    @Inject
    private JavaCodeFormatter javaCodeFormatter;
    @Inject
    private EventBus eventBus;
    private Context context;

    public void transform(Context context) throws TransformerException {
        this.context = context;
        try {
            Package outPackage = this.getRootPackage(context);
            this.sourceDirectoryPackageName = "";
            this.checkStereotypeRootPackage(outPackage);
            EList elements = outPackage.allOwnedElements();
            for (Element element : elements) {
                EList stereotypes = element.getAppliedStereotypes();
                for (Stereotype stereotype : stereotypes) {
                    if (stereotype.getName().equals(STEREOTYPE_SOURCEDIRECTORY)) {
                        Package packagez = (Package)element;
                        this.sourceDirectoryPackageName = packagez.getName();
                        logger.log(Level.FINE, "SourceDirectory package name: " + this.sourceDirectoryPackageName);
                    }
                    if (stereotype.getName().equals(STEREOTYPE_ENTITY) || stereotype.getName().equals(STEREOTYPE_SERVICE)) {
                        this.generateInterfaceForEntityAndService(element, stereotype);
                    }
                    if (stereotype.getName().equals(STEREOTYPE_EXCEPTION) || stereotype.getName().equals(STEREOTYPE_APPLICATIONEXCEPTION)) {
                        this.generateCheckedException(element, stereotype);
                    }
                    if (!stereotype.getName().equals(STEREOTYPE_UNEXPECTEDEXCEPTION)) continue;
                    this.generateUncheckedException(element, stereotype);
                }
                if (!element.eClass().getName().equals(TYPE_ENUM)) continue;
                this.generateEnum(element);
            }
        }
        catch (URISyntaxException e) {
            throw new TransformerException((Throwable)e);
        }
        catch (IOException e) {
            throw new TransformerException((Throwable)e);
        }
    }

    private void generateEnum(Element element) throws IOException {
        Enumeration clazz = (Enumeration)element;
        logger.log(Level.FINE, "Enum: " + clazz.getName());
        CompilationUnit compilationUnit = this.enumGenerator.generateEnum((Classifier)clazz, this.sourceDirectoryPackageName);
        this.generateClassFile((Classifier)clazz, compilationUnit);
    }

    private void generateInterfaceForEntityAndService(Element element, Stereotype stereotype) throws IOException {
        Class clazz = (Class)element;
        logger.log(Level.FINE, "Class: " + clazz.getName() + " - Stereotype: " + stereotype.getName());
        CompilationUnit compilationUnit = this.interfaceGenerator.generateInterface((Classifier)clazz, this.sourceDirectoryPackageName);
        this.generateClassFile((Classifier)clazz, compilationUnit);
    }

    private void generateCheckedException(Element element, Stereotype stereotype) throws IOException {
        Class clazz = (Class)element;
        logger.log(Level.FINE, "Class: " + clazz.getName() + " - Stereotype: " + stereotype.getName());
        CompilationUnit compilationUnit = this.exceptionGenerator.generateCheckedException((Classifier)clazz, this.sourceDirectoryPackageName);
        this.generateClassFile((Classifier)clazz, compilationUnit);
    }

    private void generateUncheckedException(Element element, Stereotype stereotype) throws IOException {
        Class clazz = (Class)element;
        logger.log(Level.FINE, "Class: " + clazz.getName() + " - Stereotype: " + stereotype.getName());
        CompilationUnit compilationUnit = this.exceptionGenerator.generateUncheckedException((Classifier)clazz, this.sourceDirectoryPackageName);
        this.generateClassFile((Classifier)clazz, compilationUnit);
    }

    private void checkStereotypeRootPackage(Package outPackage) {
        EList rootStereotypes = outPackage.getAppliedStereotypes();
        for (Stereotype stereotype : rootStereotypes) {
            if (!stereotype.getName().equals(STEREOTYPE_SOURCEDIRECTORY)) continue;
            Package packagez = outPackage;
            this.sourceDirectoryPackageName = packagez.getName();
            logger.log(Level.FINE, "SourceDirectory package name: " + this.sourceDirectoryPackageName);
        }
    }

    private Package getRootPackage(Context context) throws URISyntaxException {
        Package outPackage = this.packageHelper.getRootPackage(context);
        return outPackage;
    }

    private void generateClassFile(Classifier clazz, CompilationUnit compilationUnit) throws IOException {
        this.eventBus.post((Object)new BeforeClassFileGeneratedEvent(compilationUnit));
        String fullPackageName = this.packageHelper.getFullPackageName(clazz, this.sourceDirectoryPackageName);
        String formattedCode = this.javaCodeFormatter.format(compilationUnit.toString());
        this.javaFileWriter.createJavaFile(this.context, fullPackageName, clazz.getName(), formattedCode);
    }
}

