/*
 * Decompiled with CFR 0.152.
 */
package de.fumix.holidays.config;

import de.fumix.holidays.config.Holiday;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Stream;

public class Region {
    public final Optional<Region> parent;
    public final String regionId;
    public final List<HolidayRange> holidays = new ArrayList<HolidayRange>();

    public Optional<Region> getParent() {
        return this.parent;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public List<HolidayRange> getHolidays() {
        return this.holidays;
    }

    public Region(Optional<Region> parent, String abbrev) {
        this.parent = parent;
        this.regionId = abbrev;
        parent.map(Region::getHolidays).ifPresent(parentHolidays -> this.holidays.addAll((Collection<HolidayRange>)parentHolidays));
    }

    public Region withHoliday(Holiday holiday) {
        return this.withHoliday(holiday, Optional.empty(), Optional.empty());
    }

    public Region withHoliday(Holiday holiday, Optional<Integer> from, Optional<Integer> to) {
        HolidayRange holidayRange = new HolidayRange(holiday, from, to);
        this.holidays.add(holidayRange);
        return this;
    }

    public String getName(ResourceBundle holidaysBundle) {
        return holidaysBundle.getString("region." + this.regionId);
    }

    public Stream<Holiday> holidaysIn(int year) {
        return this.holidays.stream().filter(h -> !h.fromYear.isPresent() || h.fromYear.get() <= year).filter(h -> !h.toYear.isPresent() || h.toYear.get() >= year).map(h -> h.holiday);
    }

    public String toString() {
        return "Region{, abbrev=" + this.regionId + '}';
    }

    static class HolidayRange {
        Optional<Integer> fromYear;
        Optional<Integer> toYear;
        Holiday holiday;

        public HolidayRange(Holiday holiday, Optional<Integer> fromYear, Optional<Integer> toYear) {
            this.holiday = holiday;
            this.fromYear = fromYear;
            this.toYear = toYear;
        }
    }
}

