/*
 * Decompiled with CFR 0.152.
 */
package de.fumix.holidays.config.properties;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Optional;

class PropNode {
    final String key;
    Optional<String> value;
    LinkedHashMap<String, PropNode> children = new LinkedHashMap();

    PropNode(String key) {
        this.key = key;
        this.value = Optional.empty();
    }

    PropNode getCreateChild(String name) {
        PropNode child = this.children.get(name);
        if (child == null) {
            child = new PropNode(name);
            this.children.put(name, child);
        }
        return child;
    }

    public Collection<PropNode> getChildren() {
        return this.children.values();
    }

    public Optional<PropNode> get(String subKey) {
        String[] subKeys = subKey.split("\\.");
        return this.get(subKeys);
    }

    public Optional<PropNode> get(String[] subKeys) {
        String subKey;
        PropNode pn = this;
        String[] stringArray = subKeys;
        int n = stringArray.length;
        for (int i = 0; i < n && (pn = pn.children.get(subKey = stringArray[i])) != null; ++i) {
        }
        return Optional.ofNullable(pn);
    }

    public String getKey() {
        return this.key;
    }

    public Optional<String> getValue() {
        return this.value;
    }

    public String toString() {
        return "PropNode{key='" + this.key + '\'' + ", value=" + this.value + ", children=" + (this.children != null ? Integer.valueOf(this.children.size()) : "[null]") + '}';
    }
}

