/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import de.dagere.peass.analysis.changes.ProjectChanges;
import de.dagere.peass.ci.Messages;
import de.dagere.peass.ci.PeassProcessConfiguration;
import de.dagere.peass.ci.logs.rts.AggregatedRTSResult;
import de.dagere.peass.ci.process.IncludeExcludeParser;
import de.dagere.peass.ci.process.JenkinsLogRedirector;
import de.dagere.peass.ci.process.LocalPeassProcessManager;
import de.dagere.peass.ci.remote.RemoteVersionReader;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.config.FixedCommitConfig;
import de.dagere.peass.config.KiekerConfig;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.config.MeasurementStrategy;
import de.dagere.peass.config.StatisticalTests;
import de.dagere.peass.config.TestSelectionConfig;
import de.dagere.peass.dependency.analysis.testData.TestMethodCall;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.measurement.rca.CauseSearcherConfig;
import de.dagere.peass.measurement.rca.RCAStrategy;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.cli.shaded.org.apache.commons.lang.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.kieker.sourceinstrumentation.AllowedKiekerRecord;
import org.acegisecurity.Authentication;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class MeasureVersionBuilder
extends Builder
implements SimpleBuildStep,
Serializable {
    public static final String PEASS_FOLDER_NAME = "peass-data";
    private static final long serialVersionUID = -7455227251645979702L;
    private int VMs = 30;
    private int iterations = 5;
    private int warmup = 5;
    private int repetitions = 1000000;
    private long timeout = 5L;
    private boolean executeRCA = true;
    private boolean executeParallel = false;
    private String credentialsId;
    private int kiekerWaitTime = 10;
    private long kiekerQueueSize = 10000000L;
    private double significanceLevel = 0.01;
    private boolean redirectToNull = true;
    private boolean showStart = false;
    private boolean nightlyBuild = true;
    private int commitDiff = 1;
    private int traceSizeInMb = 100;
    private int importLogSizeInMb = 100;
    private boolean displayRTSLogs = true;
    private boolean displayLogs = true;
    private boolean displayRCALogs = true;
    private boolean generateCoverageSelection = false;
    private boolean useGC;
    private boolean measureJMH;
    private String includes = "";
    private String excludes = "";
    private String includeByRule = "";
    private String excludeByRule = "";
    private String properties = "";
    private String testGoal = "test";
    private String pl = "";
    private RCAStrategy rcaStrategy = RCAStrategy.UNTIL_SOURCE_CHANGE;
    private StatisticalTests statisticalTest = StatisticalTests.T_TEST;
    private boolean executeBeforeClassInMeasurement = false;
    private boolean onlyMeasureWorkload = false;
    private boolean onlyOneCallRecording = false;
    private boolean updateSnapshotDependencies = false;
    private boolean removeSnapshots = false;
    private boolean useAlternativeBuildfile = false;
    private boolean excludeLog4jSlf4jImpl = false;
    private boolean excludeLog4jToSlf4j = false;
    private boolean useSourceInstrumentation = true;
    private boolean useAggregation = true;
    private boolean createDefaultConstructor = false;
    private boolean directlyMeasureKieker = false;
    private boolean redirectSubprocessOutputToFile = true;
    private boolean writeAsZip = true;
    private String testTransformer = "de.dagere.peass.testtransformation.JUnitTestTransformer";
    private String testExecutor = "default";
    private String clazzFolders = "src/main/java:src/java";
    private String testClazzFolders = "src/test/java:src/test:src/androidTest/java/";
    private boolean failOnRtsError = false;
    private String excludeForTracing = "";

    @DataBoundConstructor
    public MeasureVersionBuilder() {
    }

    public void perform(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        if (!workspace.exists()) {
            throw new RuntimeException("Workspace folder " + workspace.toString() + " does not exist, please asure that the repository was correctly cloned!");
        }
        File localWorkspace = new File(run.getRootDir(), ".." + File.separator + ".." + File.separator + PEASS_FOLDER_NAME).getCanonicalFile();
        this.printRunMetadata(run, workspace, listener, localWorkspace);
        if (!localWorkspace.exists() && !localWorkspace.mkdirs()) {
            throw new RuntimeException("Was not able to create folder");
        }
        Pattern patternForBuild = this.getMaskingPattern(listener.getLogger());
        try (JenkinsLogRedirector redirector = new JenkinsLogRedirector(listener);){
            PeassProcessConfiguration peassConfig = this.buildConfiguration(workspace, env, listener, patternForBuild);
            boolean versionIsUsable = this.checkVersion(run, listener, peassConfig);
            if (versionIsUsable) {
                this.runAllSteps(run, workspace, listener, localWorkspace, peassConfig);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(listener.getLogger());
            e.printStackTrace();
            run.setResult(Result.FAILURE);
        }
    }

    private Pattern getMaskingPattern(PrintStream logger) {
        Pattern patternForBuild = null;
        if (this.credentialsId != null && !this.credentialsId.equals("")) {
            StandardUsernamePasswordCredentials credential = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)this.credentialsId), CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)}));
            if (credential != null) {
                String patternString = credential.getUsername() + "|" + credential.getPassword().getPlainText();
                patternForBuild = Pattern.compile(patternString);
            } else {
                logger.println("Could not find credential with name " + this.credentialsId);
            }
        }
        return patternForBuild;
    }

    private boolean checkVersion(Run<?, ?> run, TaskListener listener, PeassProcessConfiguration peassConfig) {
        boolean versionIsUsable;
        String versionOld;
        String version = peassConfig.getMeasurementConfig().getFixedCommitConfig().getCommit();
        if (version.equals(versionOld = peassConfig.getMeasurementConfig().getFixedCommitConfig().getCommitOld())) {
            listener.getLogger().print("Version " + version + " equals " + versionOld + "; please check your configuration");
            run.setResult(Result.FAILURE);
            versionIsUsable = false;
        } else {
            versionIsUsable = true;
        }
        return versionIsUsable;
    }

    private void runAllSteps(Run<?, ?> run, FilePath workspace, TaskListener listener, File localWorkspace, PeassProcessConfiguration peassConfig) throws IOException, InterruptedException, JsonParseException, JsonMappingException, JsonGenerationException, Exception {
        LocalPeassProcessManager processManager = new LocalPeassProcessManager(peassConfig, workspace, localWorkspace, listener, run);
        AggregatedRTSResult tests = processManager.rts();
        listener.getLogger().println("Tests: " + tests);
        if (tests == null || !tests.getResult().isRunning()) {
            run.setResult(Result.FAILURE);
            return;
        }
        if (tests.isRtsAllError() || this.failOnRtsError && tests.isRtsAnyError()) {
            run.setResult(Result.FAILURE);
            return;
        }
        if (!this.failOnRtsError && tests.isRtsAnyError()) {
            run.setResult(Result.UNSTABLE);
        }
        processManager.visualizeRTSResults(run, tests.getLogSummary());
        if (tests.getResult().getTests().size() > 0) {
            this.measure(run, processManager, tests.getResult().getTests());
        } else {
            listener.getLogger().println("No tests selected; no measurement executed");
        }
    }

    private void measure(Run<?, ?> run, LocalPeassProcessManager processManager, Set<TestMethodCall> tests) throws IOException, InterruptedException, JsonParseException, JsonMappingException, JsonGenerationException, Exception {
        boolean worked = processManager.measure(tests);
        if (!worked) {
            run.setResult(Result.FAILURE);
            return;
        }
        ProjectChanges changes = processManager.visualizeMeasurementResults(run);
        if (this.executeRCA) {
            CauseSearcherConfig causeSearcherConfig = this.generateCauseSearchConfig();
            boolean rcaWorked = processManager.rca(changes, causeSearcherConfig);
            processManager.visualizeRCAResults(run, changes);
            if (!rcaWorked) {
                run.setResult(Result.FAILURE);
                return;
            }
        }
    }

    private PeassProcessConfiguration buildConfiguration(FilePath workspace, EnvVars env, TaskListener listener, Pattern pattern) throws IOException, InterruptedException {
        MeasurementConfig configWithRealGitVersions = this.generateMeasurementConfig(workspace, listener);
        EnvironmentVariables peassEnv = new EnvironmentVariables(this.properties);
        for (Map.Entry entry : env.entrySet()) {
            System.out.println("Adding environment: " + (String)entry.getKey() + " " + (String)entry.getValue());
            peassEnv.getEnvironmentVariables().put((String)entry.getKey(), (String)entry.getValue());
        }
        TestSelectionConfig dependencyConfig = new TestSelectionConfig(1, false, true, this.generateCoverageSelection, this.writeAsZip);
        configWithRealGitVersions.getExecutionConfig().setGitCryptKey((String)peassEnv.getEnvironmentVariables().get("GIT_CRYPT_KEY"));
        PeassProcessConfiguration peassConfig = new PeassProcessConfiguration(this.updateSnapshotDependencies, configWithRealGitVersions, dependencyConfig, peassEnv, this.importLogSizeInMb, this.displayRTSLogs, this.displayLogs, this.displayRCALogs, pattern);
        return peassConfig;
    }

    private CauseSearcherConfig generateCauseSearchConfig() {
        boolean ignoreEOIs = this.useAggregation;
        CauseSearcherConfig causeSearcherConfig = new CauseSearcherConfig(null, ignoreEOIs, 0.01, false, ignoreEOIs, this.rcaStrategy, 1);
        return causeSearcherConfig;
    }

    private MeasurementConfig generateMeasurementConfig(FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        MeasurementConfig measurementConfig = this.getMeasurementConfig();
        listener.getLogger().println("Starting RemoteVersionReader");
        RemoteVersionReader remoteVersionReader = new RemoteVersionReader(measurementConfig, listener);
        MeasurementConfig configWithRealGitVersions = (MeasurementConfig)workspace.act((FilePath.FileCallable)remoteVersionReader);
        FixedCommitConfig fixedCommitConfig = configWithRealGitVersions.getFixedCommitConfig();
        listener.getLogger().println("Read version: " + fixedCommitConfig.getCommit() + " " + fixedCommitConfig.getCommitOld());
        return configWithRealGitVersions;
    }

    private void printRunMetadata(Run<?, ?> run, FilePath workspace, TaskListener listener, File localWorkspace) {
        listener.getLogger().println("Current Job: " + this.getJobName(run));
        listener.getLogger().println("Local workspace " + workspace.toString() + " Run dir: " + run.getRootDir() + " Local workspace: " + localWorkspace);
        listener.getLogger().println("VMs: " + this.VMs + " Iterations: " + this.iterations + " Warmup: " + this.warmup + " Repetitions: " + this.repetitions);
        listener.getLogger().println("measureJMH: " + this.measureJMH);
        listener.getLogger().println("Includes: " + this.includes + " RCA: " + this.executeRCA);
        listener.getLogger().println("Excludes: " + this.excludes);
        listener.getLogger().println("Strategy: " + this.rcaStrategy + " Source Instrumentation: " + this.useSourceInstrumentation + " Aggregation: " + this.useAggregation);
        listener.getLogger().println("Create default constructor: " + this.createDefaultConstructor);
        listener.getLogger().println("Fail on error in RTS: " + this.failOnRtsError);
        listener.getLogger().println("Redirect subprocess output to file: " + this.redirectSubprocessOutputToFile);
    }

    private String getJobName(Run<?, ?> run) {
        return run.getParent().getFullDisplayName();
    }

    public MeasurementConfig getMeasurementConfig() throws JsonParseException, JsonMappingException, IOException {
        if (this.significanceLevel == 0.0) {
            this.significanceLevel = 0.01;
        }
        MeasurementConfig config = new MeasurementConfig(this.VMs);
        config.getStatisticsConfig().setType1error(this.significanceLevel);
        config.getStatisticsConfig().setStatisticTest(this.statisticalTest);
        config.setIterations(this.iterations);
        config.setWarmup(this.warmup);
        config.setRepetitions(this.repetitions);
        config.setUseGC(this.useGC);
        config.setEarlyStop(false);
        config.getExecutionConfig().setShowStart(this.showStart);
        config.setDirectlyMeasureKieker(this.directlyMeasureKieker);
        if (this.executeParallel) {
            System.out.println("Measuring parallel");
            config.setMeasurementStrategy(MeasurementStrategy.PARALLEL);
        } else {
            config.setMeasurementStrategy(MeasurementStrategy.SEQUENTIAL);
            System.out.println("executeparallel is false");
        }
        this.parameterizeKiekerConfig(config.getKiekerConfig());
        if (this.useAggregation && !this.useSourceInstrumentation) {
            throw new RuntimeException("Aggregation may only be used with source instrumentation currently.");
        }
        if (this.commitDiff <= 0) {
            throw new RuntimeException("The version difference should be at least 1, but was " + this.commitDiff);
        }
        if (this.nightlyBuild && this.commitDiff != 1) {
            throw new RuntimeException("If nightly build is set, do not set versionDiff! nightlyBuild will automatically select the last tested version.");
        }
        config.getFixedCommitConfig().setCommit("HEAD");
        String oldVersion = this.getOldVersion();
        config.getFixedCommitConfig().setCommitOld(oldVersion);
        this.parameterizeExecutionConfig(config.getExecutionConfig());
        System.out.println("Building, iterations: " + this.iterations + " test goal: " + this.testGoal);
        return config;
    }

    private void parameterizeExecutionConfig(ExecutionConfig executionConfig) throws IOException, JsonParseException, JsonMappingException {
        if (this.measureJMH) {
            executionConfig.setTestTransformer("de.dagere.peass.dependency.jmh.JmhTestTransformer");
            executionConfig.setTestExecutor("de.dagere.peass.dependency.jmh.JmhTestExecutor");
        }
        executionConfig.setTimeout(this.timeout * 60L * 1000L);
        executionConfig.setExecuteBeforeClassInMeasurement(this.executeBeforeClassInMeasurement);
        executionConfig.setOnlyMeasureWorkload(this.onlyMeasureWorkload);
        if (this.onlyMeasureWorkload && this.repetitions != 1) {
            throw new RuntimeException("If onlyMeasureWorkload is set, repetitions should be 1, but are " + this.repetitions);
        }
        executionConfig.setRedirectToNull(this.redirectToNull);
        executionConfig.setRemoveSnapshots(this.removeSnapshots);
        executionConfig.setExcludeLog4jSlf4jImpl(this.excludeLog4jSlf4jImpl);
        executionConfig.setExcludeLog4jToSlf4j(this.excludeLog4jToSlf4j);
        executionConfig.setIncludes(IncludeExcludeParser.getStringList(this.includes));
        executionConfig.setExcludes(IncludeExcludeParser.getStringList(this.excludes));
        executionConfig.setIncludeByRule(IncludeExcludeParser.getStringListSimple(this.includeByRule));
        executionConfig.setExcludeByRule(IncludeExcludeParser.getStringListSimple(this.excludeByRule));
        executionConfig.setUseAlternativeBuildfile(this.useAlternativeBuildfile);
        executionConfig.setRedirectSubprocessOutputToFile(this.redirectSubprocessOutputToFile);
        executionConfig.setTestTransformer(this.testTransformer);
        executionConfig.setTestExecutor(this.testExecutor);
        if (this.clazzFolders != null && !"".equals(this.clazzFolders.trim())) {
            List pathes = ExecutionConfig.buildFolderList((String)this.clazzFolders);
            List clazzFolders2 = executionConfig.getClazzFolders();
            clazzFolders2.clear();
            clazzFolders2.addAll(pathes);
        }
        if (this.testClazzFolders != null && !"".equals(this.testClazzFolders.trim())) {
            List testPathes = ExecutionConfig.buildFolderList((String)this.testClazzFolders);
            List testClazzFolders2 = executionConfig.getTestClazzFolders();
            testClazzFolders2.clear();
            testClazzFolders2.addAll(testPathes);
        }
        if (this.testGoal != null && !"".equals(this.testGoal)) {
            executionConfig.setTestGoal(this.testGoal);
        }
        if (this.pl != null && !"".equals(this.pl)) {
            executionConfig.setPl(this.pl);
        }
        if (executionConfig.isExecuteBeforeClassInMeasurement() && executionConfig.isOnlyMeasureWorkload()) {
            throw new RuntimeException("executeBeforeClassInMeasurement may only be activated if onlyMeasureWorkload is deactivated!");
        }
    }

    private void parameterizeKiekerConfig(KiekerConfig kiekerConfig) {
        kiekerConfig.setKiekerQueueSize(this.kiekerQueueSize);
        if (this.useSourceInstrumentation) {
            kiekerConfig.setUseSourceInstrumentation(true);
            kiekerConfig.setUseSelectiveInstrumentation(true);
            kiekerConfig.setUseCircularQueue(true);
        }
        if (this.useAggregation) {
            kiekerConfig.setUseAggregation(true);
            kiekerConfig.setRecord(AllowedKiekerRecord.DURATION);
        } else {
            kiekerConfig.setUseAggregation(false);
            kiekerConfig.setRecord(AllowedKiekerRecord.OPERATIONEXECUTION);
        }
        if (!"".equals(this.excludeForTracing)) {
            LinkedHashSet<String> excludeSet = IncludeExcludeParser.getStringSet(this.excludeForTracing);
            kiekerConfig.setExcludeForTracing(excludeSet);
        }
        kiekerConfig.setTraceSizeInMb((long)this.traceSizeInMb);
        kiekerConfig.setOnlyOneCallRecording(this.onlyOneCallRecording);
        kiekerConfig.setCreateDefaultConstructor(this.createDefaultConstructor);
        kiekerConfig.setKiekerWaitTime(this.kiekerWaitTime);
    }

    private String getOldVersion() throws IOException, JsonParseException, JsonMappingException {
        String oldVersion = this.nightlyBuild ? null : "HEAD~" + this.commitDiff;
        return oldVersion;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public int getVMs() {
        return this.VMs;
    }

    @DataBoundSetter
    public void setVMs(int vMs) {
        this.VMs = vMs;
    }

    public int getIterations() {
        return this.iterations;
    }

    @DataBoundSetter
    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public int getWarmup() {
        return this.warmup;
    }

    @DataBoundSetter
    public void setWarmup(int warmup) {
        this.warmup = warmup;
    }

    public int getRepetitions() {
        return this.repetitions;
    }

    @DataBoundSetter
    public void setRepetitions(int repetitions) {
        this.repetitions = repetitions;
    }

    public long getTimeout() {
        return this.timeout;
    }

    @DataBoundSetter
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public int getKiekerWaitTime() {
        return this.kiekerWaitTime;
    }

    @DataBoundSetter
    public void setKiekerWaitTime(int kiekerWaitTime) {
        this.kiekerWaitTime = kiekerWaitTime;
    }

    public double getSignificanceLevel() {
        return this.significanceLevel;
    }

    @DataBoundSetter
    public void setSignificanceLevel(double significanceLevel) {
        this.significanceLevel = significanceLevel;
    }

    public boolean isNightlyBuild() {
        return this.nightlyBuild;
    }

    @DataBoundSetter
    public void setNightlyBuild(boolean nightlyBuild) {
        this.nightlyBuild = nightlyBuild;
    }

    public int getCommitDiff() {
        return this.commitDiff;
    }

    @DataBoundSetter
    public void setCommitDiff(int commitDiff) {
        this.commitDiff = commitDiff;
    }

    public int getTraceSizeInMb() {
        return this.traceSizeInMb;
    }

    @DataBoundSetter
    public void setTraceSizeInMb(int traceSizeInMb) {
        this.traceSizeInMb = traceSizeInMb;
    }

    public int getImportLogSizeInMb() {
        return this.importLogSizeInMb;
    }

    @DataBoundSetter
    public void setImportLogSizeInMb(int importLogSizeInMb) {
        this.importLogSizeInMb = importLogSizeInMb;
    }

    public boolean isDisplayRTSLogs() {
        return this.displayRTSLogs;
    }

    @DataBoundSetter
    public void setDisplayRTSLogs(boolean displayRTSLogs) {
        this.displayRTSLogs = displayRTSLogs;
    }

    public boolean isDisplayLogs() {
        return this.displayLogs;
    }

    @DataBoundSetter
    public void setDisplayLogs(boolean displayLogs) {
        this.displayLogs = displayLogs;
    }

    public boolean isDisplayRCALogs() {
        return this.displayRCALogs;
    }

    @DataBoundSetter
    public void setDisplayRCALogs(boolean displayRCALogs) {
        this.displayRCALogs = displayRCALogs;
    }

    public boolean isRedirectSubprocessOutputToFile() {
        return this.redirectSubprocessOutputToFile;
    }

    @DataBoundSetter
    public void setGenerateCoverageSelection(boolean generateCoverageSelection) {
        this.generateCoverageSelection = generateCoverageSelection;
    }

    public boolean isGenerateCoverageSelection() {
        return this.generateCoverageSelection;
    }

    @DataBoundSetter
    public void setRedirectSubprocessOutputToFile(boolean redirectSubprocessOutputToFile) {
        this.redirectSubprocessOutputToFile = redirectSubprocessOutputToFile;
    }

    public boolean isUseGC() {
        return this.useGC;
    }

    @DataBoundSetter
    public void setUseGC(boolean useGC) {
        this.useGC = useGC;
    }

    public String getIncludes() {
        return this.includes;
    }

    @DataBoundSetter
    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    @DataBoundSetter
    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getIncludeByRule() {
        return this.includeByRule;
    }

    @DataBoundSetter
    public void setIncludeByRule(String includeByRule) {
        this.includeByRule = includeByRule;
    }

    public String getExcludeByRule() {
        return this.excludeByRule;
    }

    @DataBoundSetter
    public void setExcludeByRule(String excludeByRule) {
        this.excludeByRule = excludeByRule;
    }

    public boolean isExecuteRCA() {
        return this.executeRCA;
    }

    @DataBoundSetter
    public void setProperties(String properties) {
        this.properties = properties;
    }

    public String getProperties() {
        return this.properties;
    }

    public String getTestGoal() {
        return this.testGoal;
    }

    @DataBoundSetter
    public void setTestGoal(String testGoal) {
        this.testGoal = testGoal;
    }

    public String getPl() {
        return this.pl;
    }

    @DataBoundSetter
    public void setPl(String pl) {
        this.pl = pl;
    }

    @DataBoundSetter
    public void setExecuteRCA(boolean executeRCA) {
        this.executeRCA = executeRCA;
    }

    public boolean isExecuteBeforeClassInMeasurement() {
        return this.executeBeforeClassInMeasurement;
    }

    @DataBoundSetter
    public void setExecuteBeforeClassInMeasurement(boolean executeBeforeClassInMeasurement) {
        this.executeBeforeClassInMeasurement = executeBeforeClassInMeasurement;
    }

    public boolean isOnlyMeasureWorkload() {
        return this.onlyMeasureWorkload;
    }

    @DataBoundSetter
    public void setOnlyMeasureWorkload(boolean onlyMeasureWorkload) {
        this.onlyMeasureWorkload = onlyMeasureWorkload;
    }

    public RCAStrategy getMeasurementMode() {
        return this.rcaStrategy;
    }

    @DataBoundSetter
    public void setMeasurementMode(RCAStrategy measurementMode) {
        this.rcaStrategy = measurementMode;
    }

    public StatisticalTests getStatisticalTest() {
        return this.statisticalTest;
    }

    @DataBoundSetter
    public void setStatisticalTest(StatisticalTests statisticalTest) {
        this.statisticalTest = statisticalTest;
    }

    public boolean isUseSourceInstrumentation() {
        return this.useSourceInstrumentation;
    }

    @DataBoundSetter
    public void setUseSourceInstrumentation(boolean useSourceInstrumentation) {
        this.useSourceInstrumentation = useSourceInstrumentation;
    }

    public boolean isUseAggregation() {
        return this.useAggregation;
    }

    @DataBoundSetter
    public void setUseAggregation(boolean useAggregation) {
        this.useAggregation = useAggregation;
    }

    public boolean isExecuteParallel() {
        return this.executeParallel;
    }

    @DataBoundSetter
    public void setExecuteParallel(boolean executeParallel) {
        this.executeParallel = executeParallel;
    }

    public boolean isCreateDefaultConstructor() {
        return this.createDefaultConstructor;
    }

    @DataBoundSetter
    public void setCreateDefaultConstructor(boolean createDefaultConstructor) {
        this.createDefaultConstructor = createDefaultConstructor;
    }

    public boolean isUpdateSnapshotDependencies() {
        return this.updateSnapshotDependencies;
    }

    @DataBoundSetter
    public void setUpdateSnapshotDependencies(boolean updateSnapshotDependencies) {
        this.updateSnapshotDependencies = updateSnapshotDependencies;
    }

    public boolean isRemoveSnapshots() {
        return this.removeSnapshots;
    }

    @DataBoundSetter
    public void setRemoveSnapshots(boolean removeSnapshots) {
        this.removeSnapshots = removeSnapshots;
    }

    public boolean isUseAlternativeBuildfile() {
        return this.useAlternativeBuildfile;
    }

    @DataBoundSetter
    public void setUseAlternativeBuildfile(boolean useAlternativeBuildfile) {
        this.useAlternativeBuildfile = useAlternativeBuildfile;
    }

    public boolean isExcludeLog4jSlf4jImpl() {
        return this.excludeLog4jSlf4jImpl;
    }

    @DataBoundSetter
    public void setExcludeLog4jSlf4jImpl(boolean excludeLog4jSlf4jImpl) {
        this.excludeLog4jSlf4jImpl = excludeLog4jSlf4jImpl;
    }

    public boolean isExcludeLog4jToSlf4j() {
        return this.excludeLog4jToSlf4j;
    }

    @DataBoundSetter
    public void setExcludeLog4jToSlf4j(boolean excludeLog4jToSlf4j) {
        this.excludeLog4jToSlf4j = excludeLog4jToSlf4j;
    }

    public boolean isRedirectToNull() {
        return this.redirectToNull;
    }

    @DataBoundSetter
    public void setRedirectToNull(boolean redirectToNull) {
        this.redirectToNull = redirectToNull;
    }

    public boolean isShowStart() {
        return this.showStart;
    }

    @DataBoundSetter
    public void setShowStart(boolean showStart) {
        this.showStart = showStart;
    }

    public boolean isMeasureJMH() {
        return this.measureJMH;
    }

    @DataBoundSetter
    public void setMeasureJMH(boolean measureJMH) {
        this.measureJMH = measureJMH;
    }

    public String getTestExecutor() {
        return this.testExecutor;
    }

    @DataBoundSetter
    public void setTestExecutor(String testExecutor) {
        this.testExecutor = testExecutor;
    }

    public String getTestTransformer() {
        return this.testTransformer;
    }

    @DataBoundSetter
    public void setTestTransformer(String testTransformer) {
        this.testTransformer = testTransformer;
    }

    public String getClazzFolders() {
        return this.clazzFolders;
    }

    @DataBoundSetter
    public void setClazzFolders(String clazzFolders) {
        this.clazzFolders = clazzFolders;
    }

    public String getTestClazzFolders() {
        return this.testClazzFolders;
    }

    @DataBoundSetter
    public void setTestClazzFolders(String testClazzFolders) {
        this.testClazzFolders = testClazzFolders;
    }

    public boolean isFailOnRtsError() {
        return this.failOnRtsError;
    }

    @DataBoundSetter
    public void setFailOnRtsError(boolean failOnRtsError) {
        this.failOnRtsError = failOnRtsError;
    }

    public long getKiekerQueueSize() {
        return this.kiekerQueueSize;
    }

    @DataBoundSetter
    public void setKiekerQueueSize(long kiekerQueueSize) {
        this.kiekerQueueSize = kiekerQueueSize;
    }

    public boolean isOnlyOneCallRecording() {
        return this.onlyOneCallRecording;
    }

    @DataBoundSetter
    public void setOnlyOneCallRecording(boolean onlyOneCallRecording) {
        this.onlyOneCallRecording = onlyOneCallRecording;
    }

    public String getExcludeForTracing() {
        return this.excludeForTracing;
    }

    @DataBoundSetter
    public void setExcludeForTracing(String excludeForTracing) {
        this.excludeForTracing = excludeForTracing;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public boolean isWriteAsZip() {
        return this.writeAsZip;
    }

    @DataBoundSetter
    public void setWriteAsZip(boolean writeAsZip) {
        this.writeAsZip = writeAsZip;
    }

    public boolean isDirectlyMeasureKieker() {
        return this.directlyMeasureKieker;
    }

    @DataBoundSetter
    public void setDirectlyMeasureKieker(boolean directlyMeasureKieker) {
        this.directlyMeasureKieker = directlyMeasureKieker;
    }

    @Symbol(value={"measure"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckName(@QueryParameter String value, @QueryParameter boolean useFrench) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)("Strange value: " + value));
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.MeasureVersion_DescriptorImpl_DisplayName();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project, @QueryParameter String url, @QueryParameter String credentialsId) {
            if (project == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || project != null && !project.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            if (project == null) {
                FreeStyleProject fakeProject = new FreeStyleProject(Jenkins.get(), "fake-" + UUID.randomUUID().toString());
                project = fakeProject;
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(project instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)project)) : ACL.SYSTEM, project, StandardUsernamePasswordCredentials.class, new LinkedList(), CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)).includeCurrentValue(credentialsId);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item project, @QueryParameter String url, @QueryParameter String value) {
            if (project == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || project != null && !project.hasPermission(Item.EXTENDED_READ)) {
                return FormValidation.ok();
            }
            if ((value = Util.fixEmptyAndTrim((String)value)) == null) {
                return FormValidation.ok();
            }
            if ((url = Util.fixEmptyAndTrim((String)url)) == null) {
                return FormValidation.ok();
            }
            if (url.indexOf(36) >= 0) {
                return FormValidation.ok();
            }
            for (ListBoxModel.Option o : CredentialsProvider.listCredentials(StandardUsernameCredentials.class, (Item)project, (Authentication)(project instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)project)) : ACL.SYSTEM), new LinkedList(), (CredentialsMatcher)CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class))) {
                if (!StringUtils.equals((String)value, (String)o.value)) continue;
                return FormValidation.ok();
            }
            return FormValidation.warning((String)("Cannot find any credentials with id " + value));
        }

        public ListBoxModel doFillMeasurementModeItems(@QueryParameter String measurementMode) {
            ListBoxModel model = new ListBoxModel();
            model.add((Object)new ListBoxModel.Option("Complete", "COMPLETE", "COMPLETE".equals(measurementMode)));
            model.add((Object)new ListBoxModel.Option("Levelwise", "LEVELWISE", "LEVELWISE".equals(measurementMode)));
            model.add((Object)new ListBoxModel.Option("Until Source Change", "UNTIL_SOURCE_CHANGE", "UNTIL_SOURCE_CHANGE".equals(measurementMode)));
            model.add((Object)new ListBoxModel.Option("Constant Levels (NOT IMPLEMENTED)", "CONSTANT_LEVELS", "CONSTANT_LEVELS".equals(measurementMode)));
            return model;
        }

        public ListBoxModel doFillStatisticalTestItems(@QueryParameter String statisticalTest) {
            ListBoxModel model = new ListBoxModel();
            model.add((Object)new ListBoxModel.Option("T-Test", "T_TEST", "T_TEST".equals(statisticalTest)));
            model.add((Object)new ListBoxModel.Option("Mann-Whitney-Test", "MANN_WHITNEY_TEST", "MANN_WHITNEY_TEST".equals(statisticalTest)));
            model.add((Object)new ListBoxModel.Option("Confidence Interval Comparison", "CONFIDENCE_INTERVAL", "CONFIDENCE_INTERVAL".equals(statisticalTest)));
            return model;
        }
    }
}

