/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci;

import de.dagere.peass.analysis.changes.Change;
import de.dagere.peass.analysis.changes.Changes;
import de.dagere.peass.analysis.measurement.ProjectStatistics;
import de.dagere.peass.ci.Messages;
import de.dagere.peass.ci.VisibleAction;
import de.dagere.peass.ci.helper.HistogramValues;
import de.dagere.peass.ci.helper.UnitConverter;
import de.dagere.peass.ci.rca.RCAVisualizer;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependency.analysis.testData.TestMethodCall;
import de.dagere.peass.measurement.statistics.StatisticUtil;
import de.dagere.peass.measurement.statistics.data.TestcaseStatistic;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvnet.localizer.LocaleProvider;

public class MeasurementOverviewAction
extends VisibleAction {
    private static final Logger LOG = LogManager.getLogger(MeasurementOverviewAction.class);
    private MeasurementConfig config;
    private Changes changes;
    private ProjectStatistics statistics;
    private final Map<String, TestcaseStatistic> noWarmupStatistics;
    private Map<String, HistogramValues> measurements;
    private String prefix;
    private Map<String, MeasurementConfig> updatedConfigurations;

    public MeasurementOverviewAction(int id, MeasurementConfig config, Changes changes, ProjectStatistics statistics, Map<String, TestcaseStatistic> noWarmupStatistics, Map<String, HistogramValues> measurements, Map<String, MeasurementConfig> updatedConfigurations) {
        super(id);
        this.config = config;
        this.changes = changes;
        this.statistics = statistics;
        this.noWarmupStatistics = noWarmupStatistics;
        this.measurements = measurements;
        this.updatedConfigurations = updatedConfigurations;
        for (Map.Entry change : changes.getTestcaseChanges().entrySet()) {
            System.out.println((String)change.getKey());
        }
        this.prefix = RCAVisualizer.getLongestPrefix(measurements.keySet());
        LOG.debug("Prefix: {} Keys: {}", (Object)this.prefix, measurements.keySet());
    }

    public String getIconFileName() {
        return "/plugin/peass-ci/images/sd_slower.png";
    }

    public String getDisplayName() {
        return Messages.MeasurementOverviewAction_DisplayName();
    }

    public String getUrlName() {
        return "measurement_" + this.id;
    }

    public MeasurementConfig getConfig() {
        return this.config;
    }

    public boolean hasUpdatedConfigurations() {
        return !this.updatedConfigurations.isEmpty();
    }

    public Map<String, MeasurementConfig> getUpdatedConfigurations() {
        return this.updatedConfigurations;
    }

    public ProjectStatistics getStatistics() {
        return this.statistics;
    }

    public Changes getChanges() {
        return this.changes;
    }

    public boolean testIsChanged(String testcase) {
        boolean isChanged = false;
        for (Map.Entry changeEntry : this.changes.getTestcaseChanges().entrySet()) {
            for (Change change : (List)changeEntry.getValue()) {
                String changedTestcase = (String)changeEntry.getKey() + "#" + change.getMethod();
                if (!testcase.equals(changedTestcase)) continue;
                isChanged = true;
            }
        }
        return isChanged;
    }

    public Map<String, HistogramValues> getMeasurements() {
        return this.measurements;
    }

    public double getCriticalTValue() {
        int degreesOfFreedom = this.getDegreesOfFreedom();
        return StatisticUtil.getCriticalValueTTest((double)this.config.getStatisticsConfig().getType1error(), (long)degreesOfFreedom);
    }

    public int getDegreesOfFreedom() {
        int degreesOfFreedom = this.config.getVms() * 2 - 2;
        return degreesOfFreedom;
    }

    public double abs(double value) {
        return Math.abs(value);
    }

    public TestcaseStatistic getTestcaseStatistic(String testcase) {
        String commit = this.config.getFixedCommitConfig().getCommit();
        Map testcaseStatistic = (Map)this.statistics.getStatistics().get(commit);
        TestMethodCall testcaseObject = TestMethodCall.createFromString((String)testcase);
        return (TestcaseStatistic)testcaseStatistic.get(testcaseObject);
    }

    public TestcaseStatistic getNoWarmupStatistic(String testcase) {
        return this.noWarmupStatistics.get(testcase);
    }

    public String getReducedName(String name) {
        return name.substring(this.prefix.length());
    }

    public String round(double value) {
        double roundedValue = (double)Math.round(value * 10000.0) / 10000.0;
        Locale locale = LocaleProvider.getLocale();
        return NumberFormat.getInstance(locale).format(roundedValue);
    }

    public double getMeanOfValues(double[] values) {
        return new DescriptiveStatistics(values).getMean();
    }

    public int getFactorByMean(double mean) {
        return UnitConverter.getFactorByMean(mean);
    }

    public String getUnitByFactor(int factor) {
        return UnitConverter.getUnitByFactor(factor);
    }

    public double[] divideValuesByFactor(double[] values, MeasurementConfig measurementConfig, int factor) {
        return Arrays.stream(values).map(value -> value / (double)measurementConfig.getRepetitions() / (double)factor).toArray();
    }

    public String getValuesReadable(double[] values) {
        return Arrays.toString(values);
    }
}

