/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci;

import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.config.TestSelectionConfig;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class PeassProcessConfiguration
implements Serializable {
    private static final long serialVersionUID = 5858433989302224348L;
    private final boolean updateSnapshotDependencies;
    private final MeasurementConfig measurementConfig;
    private final TestSelectionConfig dependencyConfig;
    private final EnvironmentVariables envVars;
    private final Pattern pattern;
    private final int importLogSizeInMb;
    private final boolean displayRTSLogs;
    private final boolean displayLogs;
    private final boolean displayRCALogs;

    public PeassProcessConfiguration(boolean updateSnapshotDependencies, MeasurementConfig measurementConfig, TestSelectionConfig dependencyConfig, EnvironmentVariables envVars, int importLogSizeInMb, boolean displayRTSLogs, boolean displayLogs, boolean displayRCALogs, Pattern pattern) {
        this.updateSnapshotDependencies = updateSnapshotDependencies;
        this.measurementConfig = measurementConfig;
        this.dependencyConfig = dependencyConfig;
        this.envVars = envVars;
        this.importLogSizeInMb = importLogSizeInMb;
        this.displayRTSLogs = displayRTSLogs;
        this.displayLogs = displayLogs;
        this.displayRCALogs = displayRCALogs;
        this.pattern = pattern;
    }

    public boolean isUpdateSnapshotDependencies() {
        return this.updateSnapshotDependencies;
    }

    public MeasurementConfig getMeasurementConfig() {
        return this.measurementConfig;
    }

    public TestSelectionConfig getDependencyConfig() {
        return this.dependencyConfig;
    }

    public EnvironmentVariables getEnvVars() {
        return this.envVars;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public int getImportLogSizeInMb() {
        return this.importLogSizeInMb;
    }

    public boolean isDisplayRTSLogs() {
        return this.displayRTSLogs;
    }

    public boolean isDisplayLogs() {
        return this.displayLogs;
    }

    public boolean isDisplayRCALogs() {
        return this.displayRCALogs;
    }

    public String getLogText(File logfile) throws IOException {
        long filesize = logfile.length() / 0x100000L;
        String logData = filesize < (long)this.getImportLogSizeInMb() ? FileUtils.readFileToString((File)logfile, (Charset)StandardCharsets.UTF_8) : "Could not import " + logfile + " since its size was " + filesize + " MB but only " + this.getImportLogSizeInMb() + " MB was allowed.";
        return logData;
    }
}

