/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import de.dagere.peass.ci.Messages;
import de.dagere.peass.ci.persistence.BuildMeasurementValues;
import de.dagere.peass.ci.persistence.TestMeasurementValues;
import de.dagere.peass.ci.persistence.TrendFileUtil;
import de.dagere.peass.measurement.statistics.data.TestcaseStatistic;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Project;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

public class TrendAction
implements Action {
    private Job<?, ?> project;

    public TrendAction(Job<?, ?> project) {
        this.project = project;
    }

    public int getBuildStepsCount() {
        if (this.project instanceof WorkflowJob) {
            WorkflowJob job = (WorkflowJob)this.project;
            return job.getBuilds().size();
        }
        if (this.project instanceof Project) {
            return ((Project)this.project).getBuilders().size();
        }
        return 0;
    }

    public LinkedHashMap<Integer, Double> getMeanMap(String testcase) throws InterruptedException, IOException {
        LinkedHashMap<Integer, Double> meanMap = new LinkedHashMap<Integer, Double>();
        BuildMeasurementValues values = this.readValues();
        TestMeasurementValues testMeasurementValues = values.getValues().get(testcase);
        for (Map.Entry<Integer, TestcaseStatistic> vals : testMeasurementValues.getStatistics().entrySet()) {
            meanMap.put(vals.getKey(), vals.getValue().getMeanCurrent());
        }
        return meanMap;
    }

    public LinkedHashMap<Integer, Double> getLowerBound(String testcase) throws JsonParseException, JsonMappingException, InterruptedException, IOException {
        LinkedHashMap<Integer, Double> deviationMap = new LinkedHashMap<Integer, Double>();
        BuildMeasurementValues values = this.readValues();
        TestMeasurementValues testMeasurementValues = values.getValues().get(testcase);
        for (Map.Entry<Integer, TestcaseStatistic> vals : testMeasurementValues.getStatistics().entrySet()) {
            deviationMap.put(vals.getKey(), vals.getValue().getMeanCurrent() - vals.getValue().getDeviationCurrent());
        }
        return deviationMap;
    }

    public LinkedHashMap<Integer, Double> getUpperBound(String testcase) throws JsonParseException, JsonMappingException, InterruptedException, IOException {
        LinkedHashMap<Integer, Double> deviationMap = new LinkedHashMap<Integer, Double>();
        BuildMeasurementValues values = this.readValues();
        TestMeasurementValues testMeasurementValues = values.getValues().get(testcase);
        for (Map.Entry<Integer, TestcaseStatistic> vals : testMeasurementValues.getStatistics().entrySet()) {
            deviationMap.put(vals.getKey(), vals.getValue().getMeanCurrent() + vals.getValue().getDeviationCurrent());
        }
        return deviationMap;
    }

    public Set<String> getTestcases() throws JsonParseException, JsonMappingException, InterruptedException, IOException {
        BuildMeasurementValues values = this.readValues();
        return values.getValues().keySet();
    }

    public String getBuildnumbersReadable(String testcase) throws InterruptedException, IOException {
        return this.getMeanMap(testcase).keySet().toString();
    }

    public String getMeansReadable(String testcase) throws InterruptedException, IOException {
        return this.getMeanMap(testcase).values().toString();
    }

    public String getLowerBoundReadable(String testcase) throws InterruptedException, IOException {
        return this.getLowerBound(testcase).values().toString();
    }

    public String getUpperBoundReadable(String testcase) throws InterruptedException, IOException {
        return this.getUpperBound(testcase).values().toString();
    }

    private BuildMeasurementValues readValues() throws InterruptedException, IOException, JsonParseException, JsonMappingException {
        if (this.project instanceof WorkflowJob || this.project instanceof Project) {
            File localWorkspace = new File(this.project.getRootDir(), "peass-data");
            BuildMeasurementValues values = TrendFileUtil.readMeasurementValues(localWorkspace);
            return values;
        }
        return null;
    }

    public String getIconFileName() {
        return "/plugin/peass-ci/images/trend.png";
    }

    public String getDisplayName() {
        return Messages.TrendAction_DisplayName();
    }

    public String getUrlName() {
        return "stats";
    }
}

