/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.clean;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.dagere.peass.ci.Messages;
import de.dagere.peass.ci.clean.CleanAllCallable;
import de.dagere.peass.ci.clean.CleaningResult;
import de.dagere.peass.utils.Constants;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.FreeStyleProject;
import hudson.model.Job;
import hudson.model.Project;
import hudson.model.TopLevelItem;
import java.io.File;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

public class CleanAllAction
implements Action {
    private Job<?, ?> project;

    public CleanAllAction(Job<?, ?> project) {
        this.project = project;
    }

    public String clean() throws JsonProcessingException {
        CleaningResult result;
        block6: {
            if (this.project instanceof WorkflowJob || this.project instanceof Project) {
                try {
                    File persistentWorkspace = new File(this.project.getRootDir(), "peass-data");
                    FileUtils.cleanDirectory((File)persistentWorkspace);
                    if (this.project instanceof WorkflowJob) {
                        WorkflowJob job = (WorkflowJob)this.project;
                        result = this.tryCleaning((TopLevelItem)job);
                        break block6;
                    }
                    if (this.project instanceof FreeStyleProject) {
                        FreeStyleProject job = (FreeStyleProject)this.project;
                        result = this.tryCleaning((TopLevelItem)job);
                        break block6;
                    }
                    result = new CleaningResult("#FF0000", "Full cleaning currently imposible, not implemented for job type: " + this.project.getClass());
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                    result = new CleaningResult("#FF0000", "Some error appeared during cleanup, please check Jenkins server logs");
                }
            } else {
                result = new CleaningResult("#FF0000", "Unexpected project type");
            }
        }
        return Constants.OBJECTMAPPER.writeValueAsString((Object)result);
    }

    private CleaningResult tryCleaning(TopLevelItem job) throws IOException, InterruptedException {
        Jenkins jenkinsInstance = Jenkins.getInstanceOrNull();
        if (jenkinsInstance != null) {
            FilePath path = jenkinsInstance.getWorkspaceFor(job);
            if (path == null) {
                return new CleaningResult("#FF0000", "There exists no workspace for job " + job.toString());
            }
            boolean cleaningWorked = (Boolean)path.act((FilePath.FileCallable)new CleanAllCallable());
            if (cleaningWorked) {
                return new CleaningResult("#00FF00", Messages.CleanAction_Success());
            }
            return new CleaningResult("#FF0000", "Some error appeared during cleanup, please check Jenkins server logs");
        }
        return new CleaningResult("#FF0000", "Jenkins was not available");
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return Messages.CleanAllAction_DisplayName();
    }

    public String getUrlName() {
        return "cleanAll";
    }
}

